package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import java.text.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.framework.ClientContext;
 
public class SysReportMenuUtil   {

    public static def getQueryService( String conn ) {
        return InvokerProxy.instance.create("QueryService", null, conn );
    }

    public static def getReportService( String conn ) {
        return InvokerProxy.instance.create("SysReportService", null, conn );
    }

    public static def createPopupMenu( String category, def entity, def connection ) {
    	return 	createPopupMenu( category, entity, connection, null );
    }	

    public static def createPopupMenu( String category, def entity, def connection, def handler ) {
        def m = [_schemaname: "sys_report_def"];
        m.where = ["category = :cat AND state = 'DEPLOYED' ", [cat: category ] ];
        m.orderBy = "sortorder";
        def mlist = getQueryService(connection).getList(m);

        def hdlr = handler;
        if(!hdlr) {
            hdlr = { v->
                def rptDef = getReportService(connection).findReportDef( [name: v.reportid ] );
                def op = Inv.lookupOpener("sys_report_form", [reportDef: rptDef, query: entity, connection: connection ] );
                op.target = 'popup';
                op.id = v.reportid;
                return op;
            }
        }

        def pop = new PopupMenuOpener();
        mlist.each { pp->
            def isVisible = true;
            def b = pp.properties?.find{ z -> z.key == "visibleWhen"  };
            if(b) {
                try {
                    isVisible = ExpressionResolver.getInstance().evalBoolean(b.value, [entity: entity] );  
                }
                catch(ex) {
                    //
                }    
            }            
            if(isVisible == true) {
                pop.add( new SysReportMenuAction(caption:pp.title, parameters:[reportid: pp.name], handler: hdlr ));
            }    
        }
        return pop; 
    }

    
    
}