package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;


class SysReportHeaderModel {
    
    @Caller
    def caller;

    @Binding
    def binding;

	def items = [];
    def item;
    def mode = "read";
    def entity;

    def selectedItem;

    public String getConnection() {
        return caller.getConnection();
    }

    public def getPersistenceService() {
        return InvokerProxy.instance.create("PersistenceService", null, connection );
    }
    
    void buildItems() {
    	if( entity.value ) {
    		items.clear();
    		def br = new BufferedReader(new StringReader(entity.value));
    		def v = null;
    		while( (v=br.readLine())!=null ) {
    			if(v.contains("=")) {
    				def m = [:];
    				def arr = v.split("=");
    				m.key = arr[0];
    				m.value = arr[1];
    				items << m;	
    			}
    		}
    	}
    }

    def listHandler = [
    	isColumnEditable: { o,nm->
    		return (mode!='read');
    	},
    	fetchList: { o->
    		return items;
    	}
    ] as EditorListModel;

    void open() {
        mode = "read";
        buildItems();
    }

    void edit() {
        mode = "edit";
        item = [:];
    }

    void unedit() {
        mode = "read";
    }

    void copy() {
        def p = MsgBox.prompt( "Enter New Name");
        if(!p) return;
        def m = [_schemaname: "sys_report_header"];
        m.name = p.trim().replaceAll("\\s{1,}", "_").toUpperCase(); 
        m.value = entity.value;
        persistenceService.create( m );
        binding.refresh();
        entity = m;
    }

    void updateItem() {
        if( !item.key ) throw new Exception("Key is reqiuired");

        def v = items.find{ v-> v.key == item.key }
        if( v ) {
            v.value = item.value;
        }
        else {
            items << item;            
        }
        listHandler.reload();
        item = [:];    
    }

    void editItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        item = selectedItem;
        binding.refresh();
    }

    void deleteItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        items.remove( selectedItem );
        listHandler.reload();
    }

    void save() {
        def buff = new StringBuilder();
        items.each {
            buff.append( it.key +"="+it.value + "\n");    
        }
        entity.value = buff.toString();  
        entity._schemaname = "sys_report_header";
        persistenceService.update( entity );  
        mode = "read";    
    }


}