package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.*;
import com.rameses.rcp.framework.ClientContext;

class SysReportFormTestModel   {

    @Binding
    def binding;
    
    def reportDef;
    def reportInfo;
    String connection;
    def reportModel;
    def mode;
    def data;

    def selectedItem;
    def paramControls = [];
    def filterFields;
    def query = [:];
    def filters = [];
    
    public def getReportService() {
        return InvokerProxy.instance.create("SysReportService", null, connection );
    }
    

    @FormTitle
    public String getTitle() {
        return reportDef.title;
    }
    
    public Object getReportData() {
        return getReportService().getReportData( [name:reportDef.name, params:query, filters: filters, test: true ] );
    }
    
    public Map getParameters() {
        return [:];
    }

    public boolean getHasParameters() {
        if(paramControls) return true;
        if(filterFields) return true;
        return  false;
    }

    def init() {
        if(!reportDef) throw new Exception("report def is required in SysReportFormModel");
        if(reportDef.parameters) {
            loadParameters();
        }
        if(hasParameters) {
            mode = "parameter";
        }
        else {
            data = getReportData();
            if(!data) throw new Exception("No records found for query");
            if(!(data instanceof List )) data = [data];            
            listHandler.reload();
            mode = "preview";
        }
        return mode;
    }
    
    def doBack() {
        mode = "parameter"
        return mode;
    }

    def doNext() {
        mode = "preview"
        data = getReportData();
        if(!data) throw new Exception("No records found for query");
        if(!(data instanceof List )) data = [data];
        listHandler.reload();
        return "preview";
    }

    void loadParameters() {
        paramControls = [];
        reportDef.parameters.findAll{ c-> !c.custom }.each {
            paramControls << [caption: it.caption, type: it.type, name: 'query.' + it.name, required:true ]
        }
        filterFields = reportDef.parameters.findAll{ it.custom == 1 };
    }
    
    def buildSchema() {
        def cols = [];
        def r = null;
        if(data instanceof List) {
            r = data[0];
        }
        else {
            r = data;
        }
        r.each { k,v->
            cols << k;
        }
        return cols.collect{ [name:it, caption: it] };
    }
    
    def listHandler = [
        getColumns: {
            return buildSchema();
        },
        fetchList: { o->
            return data;
        },
        openItem: { dat, colName->
            //def schema = buildSchema();
            Modal.show("debug:view", [schema:[], data:dat]);
        }
    ] as BasicListModel;
    
    def viewData() {
        if(!selectedItem) throw new Exception("Please select an item");
        return Modal.show("debug:view", [schema:[], data:selectedItem]); 
    }
    
}