package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource

class SysReportDesignerInfo extends ReportModel  {

    def reportDef;
    def connection;
    
    public void setConnection( String connection ) {
        this.connection = connection;
    }

    public void setReportDef( def reportDef ) {
        this.reportDef = reportDef; 
    }
    
    
    def query = [:];
    def filters = [];

    def reportSvc; 
    def reportTemplateSvc; 
    def reportInfo;
    
    public void init() {
        if ( !reportDef ) 
            throw new Exception("reportDef  must be provided");

        if ( !reportDef.template ) 
            throw new Exception("reportDef.template  must be set");
    
        def template = reportDef.template;
        if( template.trim().contains("#{") ) {
            try {
                template = ExpressionResolver.getInstance().evalString(template, query);    
            } catch(Throwable t) {
                t.printStackTrace();
            }
        } 

        reportSvc = InvokerProxy.instance.create("SysReportService", null, connection );
        reportTemplateSvc = InvokerProxy.instance.create("SysReportTemplateService", null, connection);
        reportInfo = reportTemplateSvc.getInfo([ name: template ]);
        if ( !reportInfo )
            throw new Exception("'"+ template +"'  report template not found");
        
        if ( reportDef.useEmptyDataSource.toString() == 'true' ) {
            reportInfo.useEmptyDataSource = true; 
        } else {
            reportInfo.useEmptyDataSource = false; 
        }
        
        loadParameters(); 
    }

    public def getReportTemplateService() { 
        return reportTemplateSvc; 
    }    
    public def getReportService() {
        return reportSvc; 
    }

   
    def paramControls;
    def filterFields;

    public JRDataSource createDataSource() { 
        if ( reportInfo.useEmptyDataSource == true ) {
            return new JREmptyDataSource(); 
        }
        else {
            if ( getHasParameters() ) {
                showParameter();
            }
            return super.createDataSource(); 
        }
    }
    
    public boolean getHasParameters() {
        if(paramControls) return true;
        if(filterFields) return true;
        return  false;
    }

    public Object getReportData() { 
        return reportSvc.getReportData([ name: reportDef.name, params: query, filters: filters ]); 
    }
    public String getReportName() {
        return reportInfo.filepath;
    }
    
    void loadParameters() { 
        filterFields = [];
        paramControls = [];
        
        if ( reportDef.parameters ) {
            reportDef.parameters.findAll{( !it.custom )}.each{ 
                paramControls << [ caption: it.caption, type: it.type, name: 'query.'+ it.name, required: true ]; 
            }

            filterFields = reportDef.parameters.findAll{( it.custom == 1 )} 
        }
    }

    void show() {
        def params = [:];
        params.reportModel = this;
        params.reportTemplateService = reportTemplateSvc; 
        params.filePath = reportInfo.filepath;
        
        def op = Inv.lookupOpener('ireport_designer:show', params); 
        op.target = "process"; 
        Inv.invoke( op ); 
    }
    
    void showParameter() {
        def params = [:]; 
        params.query = query;
        params.filters = filters; 
        params.filterFields = filterFields; 
        params.paramControls = paramControls; 
        params.handler = { o-> 
            query.clear();
            filters.clear();
            
            if ( o.query ) query.putAll( o.query ); 
            if ( o.filters ) filters.addAll( o.filters ); 
        }
        
        Modal.show('sys_report_designer_parameter:open', params); 
    }
}