package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.rcp.framework.UIViewHandler
import com.rameses.rcp.framework.UIViewPanel
import java.awt.*;

class SysReportDefModel extends CrudFormModel implements UIViewHandler {
    
    @SubWindow
    def subwin;
    
    def paramType = "built-in";
    def selectedParam;
    def template;

    def queryTypes;
    
    public def getReportSvc() {
        return InvokerProxy.instance.create("SysReportDefService", null, connection );
    }
    
    public def getReportGenSvc() {
        return InvokerProxy.instance.create("SysReportGeneratorService", null, connection );
    }
    
    public def getLovSvc() {
        return InvokerProxy.instance.create("LOVService", null, connection );
    }
    
    public String getConnection() {
        return caller.connection;
    }
    
    @PropertyChangeListener 
    def listener = [
        "paramType" : {
            paramListHandler.reload();        
        },
        "template": { o->
            entity.template = o.name;
        }
    ];

    //this will reset the domain
    void afterInit() {
        domain = caller?.workunit?.workunit?.module?.getDomain();
    }
    
    // UIViewHandler implementation
    // 
    public void afterInit( String name, UIViewPanel panel ) {
       panel.putClientProperty("Module.domain", domain); 
    }
    
    void _initData() {
        queryTypes = getLovSvc().getKeyValues("REPORT_QUERY_TYPE")*.key;
        if(!entity.parameters) entity.parameters = [];
        if(!entity.properties ) entity.properties = [];
        if(entity.template) {
            template = [name: entity.template];
        }
    }
    
    String getTitle() {
        if ( mode == 'create' ) {
            return 'New Report Def'; 
        }
        return 'Report Def ('+ entity.name +')'; 
    }
    
    void afterCreate() {
        _initData();
        entity.state = "DRAFT";

        if ( subwin ) {
            subwin.title = 'New Report Def'; 
        }
    }
    
    void afterOpen() {
        _initData();
    }
    
    public void afterSave(){
        if ( mode == 'create' && subwin != null ) {
            subwin.title = 'Report Def ('+ entity.name +')'; 
        }
    }
    
    def viewData() {
        def p = [:];
        p.test = true;
        p.reportDef = entity;
        p.title =  entity.title;
        p.connection =  getConnection();
        def op = Inv.lookupOpener("sys_report_form_test", p);
        op.target = 'popup';
        return op;
        /*
        if(!entity.statement) throw new Exception("statement is required");
        def r = [querytype:entity.querytype, statement: entity.statement];
        def res = reportSvc.testStatement( r );
        throw new Exception("result is " + res.result)

        if(res.error) throw res.error;
        
        MsgBox.alert("Test OK"); 
        */
    }
    
    /*
    def fetchFields() {
        if(!entity.statement) throw new Exception("statement is required");
        def r = [querytype:entity.querytype, statement: entity.statement];
        def newlist = reportSvc.fetchFields( r );
        newlist.each { n->
            def x = params.find{it.name==n.name};
            if(x) n.putAll(x);
        }
        params = newlist;
        paramListHandler.reload();
    }
    */
    def testQuery() {
        def r = reportSvc.testQuery( [statement: entity.statement] );
        if(r.parameters) {
            MsgBox.alert("specify parameters " + r.parameters);
            return;        
        }
        MsgBox.alert("result is " + r.result);   
    } 
 
    def lookupTemplate() {
        def s = { o->
            entity.template = o.name;
            binding.refresh("entity.template");
        }
        return Inv.lookupOpener("sys_report_template:lookup", [onselect: s]);
    }

    void deploy() {
        if(!MsgBox.confirm("You are about to activate this report. Proceed?")) return;
        def r = [name: entity.name];
        reportSvc.deploy( r );
        entity.state = "DEPLOYED";
    }
    
    void undeploy() {
        if(!MsgBox.confirm("This will deactivate this report. Proceed?")) return;
        def r = [name: entity.name];
        reportSvc.undeploy( r );
        entity.state = "DRAFT";
    }
    
    def viewReport() {
        if ( !entity.template ) throw new Exception("Please specify a template");

        def p = [:];
        p.test = true;
        p.reportDef = entity;
        p.title =  entity.title;
        p.connection =  getConnection();

        def op = Inv.lookupOpener("sys_report_form", p);
        op.target = 'popup';
        return op;
    }
    
    void editReport() {
        if ( !entity.template ) throw new Exception("Please specify a template"); 
        
        def designer = ManagedObjects.instance.create( SysReportDesignerInfo.class ); 
        designer.connection = getConnection(); 
        designer.reportDef = entity; 
        designer.init(); 
        designer.show(); 
    } 

    def paramListHandler = [
        fetchList : { o->
            if(paramType == "built-in") {
                return entity.parameters.findAll{ !it.custom };    
            }
            else {
                return entity.parameters.findAll{ it.custom == 1 };
            }
        }
    ] as BasicListModel;
    

    def addParameter() {
        def params = [paramType:paramType];
        params.reportid = entity.name;
        params.connection = getConnection();
        params.saveHandler = { o->
            def parm = entity.parameters.find{ it.name == o.name };
            if(parm)throw new Exception("Parameter " + o.name + " already exists");
            if(paramType == "custom") o.custom = 1;
            entity.parameters << o;
            paramListHandler.reload();
        }
        return Inv.lookupOpener("sys_report_def_parameter:create", params );
    }
    
    def editParameter() {
         if(!selectedParam) throw new Exception("Please select an entry");
        def params = [:];
        params.reportid = entity.name;
        params.connection = getConnection();
        params.saveHandler = { o->
            def parm = entity.parameters.find{ it.name == o.name };
            if(!parm) throw new Exception("Parameter " + o.name + " not found");
            parm.putAll(o);
            paramListHandler.reload();
        }
        params.entity = selectedParam;
        return Inv.lookupOpener("sys_report_def_parameter:edit", params );
    }
    
    def removeParameter() {
        if(!selectedParam) throw new Exception("Please select an entry");
        def parm = entity.parameters.find{ it.name == selectedParam.name };
        if(!parm) throw new Exception("Parameter " + o.name + " not found");
        entity.parameters.remove(parm);
        paramListHandler.reload();
    }
    
    def selectedProperty;
    
    def propertyListHandler = [
        isColumnEditable: { o,colName->
            return (mode!='read');
        },
        fetchList: {
            if( entity.properties == null ) entity.properties = [];
            return entity.properties;
        },
        onRemoveItem: { o->
            if( mode == 'read' ) return false; 
            def v = entity.properties.find{ it.key == o.key };
            if(v) {
                entity.properties.remove(v);
            }
            return true;
        },
        addItem: { o->
            def v = entity.properties.find{ it.key == o.key };
            if(v) throw new Exception("item already exists");
            entity.properties << o;
        },
        onUpdateItem: { o->
            def v = entity.properties.find{ it.key == o.key };
            if(v) {
                v.putAll(o);
            }
        },
        createItem: { o->
            return [:];
        }
    ] as EditorListModel;    

    def selectedSubReport;
    def subReportListHandler = [
        fetchList: { o->
            def m = [:];
            m._schemaname = "sys_report_subreport_def";
            m.where = ["reportid = :id AND parentid IS NULL", [id: entity.name ]];
            return queryService.getList( m );
        }
    ] as BasicListModel;

    def addSubReport() {
        def p = [:];
        p.reportDef = entity;
        p.onSaveHandler = { o->
            subReportListHandler.reload();    
        }
        return Inv.lookupOpener( "sys_report_subreport_def:create", p );        
    }

    def editSubReport() {
        if(!selectedSubReport) throw new Exception("Subreport item must be selected");
        def p = [:];
        p.reportDef = entity;
        p.entity = selectedSubReport;
        p.connection = connection;
        p.onSaveHandler = { o->
            subReportListHandler.reload();    
        }
        return Inv.lookupOpener( "sys_report_subreport_def:open", p );        
    }

    def refreshSubReport() {
        subReportListHandler.reload();    
    }

    def removeSubReport() {
        if(!selectedSubReport) throw new Exception("Subreport item must be selected");
        def m = [_schemaname: "sys_report_subreport_def"];
        m.findBy = [objid: selectedSubReport.objid];
        persistenceService.removeEntity( m );
        subReportListHandler.reload();    
    }


    def formatNode( def o ) {
        return  [id: o.objid, name: o.name, caption:o.name, item: o ];
    }

    def  treeListModel = [
        isRootVisible: {
            return true;
        },
        isAllowOpenOnSingleClick: {
            return false; 
        },
        fetchItem: { node-> 
            // update the data of the selected node 
            if ( !node?.item ) return null; 
            def m = [_schemaname: "sys_report_subreport_def"];
            m.where = ["objid = :objid ", [objid: node.item.id]]; 
            def itm = queryService.findFirst( m ); 
            if ( !itm ) return null; 
            return formatNode( itm ); 
        },
        fetchList: { o->
            def nodes = [];
            def m = [_schemaname: "sys_report_subreport_def"];
            if( o.id == 'root' ) {
                m.where = ["reportid = :objid AND parentid IS NULL", [objid:entity.name]]; 
            }
            else {
                m.where = ["parentid = :parentid ", [parentid:o.id]];    
            }
            queryService.getList(m).each {
                nodes << formatNode( it );
            }
            return nodes;
        },
        getContextMenu: { node->
            def menu = new PopupMenuOpener();
            menu.add( new PopupAction(name:"refreshItem", caption:"Refresh", obj: this ) );
            
            menu.add( new PopupAction(name:"addItem", caption:"Add Item", parameters:node.item, obj:this ));
            if( node.item?.item?.parentid ) {
                menu.add( new PopupAction(name:"editItem", caption:"Edit", parameters:node.item, obj: this ) ); 
                menu.add( new PopupAction(name:"removeItem", caption:"Remove", parameters:node.item, obj: this ) );
            }                
            return menu;
        },
        
    ] as TreeNodeModel;

    def addItem( def o) {
        def m = [:];
        m.parentOrg = [objid: o.id, name: o.name];
        m.reportid = entity.name;
        m.onSaveHandler = { v->
            def node = treeListModel.selectedNode; 
            if (node) node.refresh(); 
        }
        def op = Inv.lookupOpener("sys_report_subreport_def:create", m );
        op.target = "popup";
        return op;  
    }

    def editItem(def o) {
        def p = [:];
        p.entity = [objid: o.id ];
        p.onSaveHandler = { v->
            def node = treeListModel.selectedNode; 
            if (node) node.refresh(); 
        }
        def op=  Inv.lookupOpener( "sys_report_subreport_def:open", p );
        op.target = "popup";
        return op;
    }
    
    void removeItem(def o) {
        if(!MsgBox.confirm("You are about to remove this node. Continue?")) return;
        def p = [_schemaname:"sys_report_subreport_def"];
        p.objid = o.id;
        persistenceService.removeEntity( p );
        def node = treeListModel.selectedNode; 
        if (node) node.remove(); 
    }
    
    def refreshItem() {
        def node = treeListModel.selectedNode; 
        if (node) node.refresh(); 
    }
    
    def viewFromWeb() {
        def p = MsgBox.prompt("Enter parameters");
        if(!p) return null;
        def arr = p.split("&");
        def params = [reportid: entity.name ];
        arr.each {
            def r = it.split("=");
            if(r.length>1) {
                params.put( r[0], r[1] );
            }
        }
        def weburl = getReportGenSvc().buildWebUrl( params );
        Desktop.getDesktop().browse( new URL(weburl).toURI() );
    }

    //additional functionality. Different output renderers
    def selectedTemplate;
    def templateListHandler = [
        fetchList: {
            def m = [_schemaname: "sys_report_output_template"];
            m.findBy = [parentid: entity.name ];
            return queryService.getList( m );
        },
        openItem: { o, colName ->
            def m = [:];
            m.entity = o; 
            m.mode = "read";
            m.parentid = entity.name;
            return Inv.lookupOpener( "sys_report_output_template:open", m );         
        }
    ] as BasicListModel;

    def addTemplate() {
        def m = [:];
        m.parentid = entity.name;
        m.saveHandler = {
            templateListHandler.reload();    
        }
        return Inv.lookupOpener( "sys_report_output_template:create", m );
    }

    void removeTemplate() {
        if(!selectedTemplate) throw new Exception("Please select an item");
        if(!MsgBox.confirm("You are about to remove this entry. This data will be lost once remove. Proceed?")) return;
        def m = [_schemaname: "sys_report_output_template"];
        m.objid = selectedTemplate.objid;
        persistenceService.removeEntity( m );    
        templateListHandler.reload();
    }

    def editTemplate() {
        if(!selectedTemplate) return;
        def m = [:];
        m.entity = selectedTemplate;
        m.parentid = entity.name;
        m.mode = "edit";
        m.saveHandler =  {
            templateListHandler.reload();    
        }
        return Inv.lookupOpener( "sys_report_output_template:open", m );        
    }

    def testTemplate() {
        if(!selectedTemplate) throw new Exception("Please select an item");
               
    }


    public def viewHeaders() {
        return Inv.lookupOpener("sys_report_header:lookup"); 
    }

    //HEADERS
    def lookupReportHeader() {
        def s = { o->
            entity.put("reportheader",o.name);
            binding.refresh();
        }
        return Inv.lookupOpener("sys_report_header:lookup", [onselect: s]);    
    }

    def clearReportHeader() {
        entity.put("reportheader", null);
        binding.refresh();    
    }

}