package com.rameses.jasper.models;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import com.rameses.email.*;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.*;


public class SysMessageTemplateModel extends CrudFormModel {
    

    public String getConnection() {
        return caller.getConnection();
    }

    public def getDataSvc() {
        return InvokerProxy.instance.create("SysReportDataService", null, connection );
    }
    
    public def getTemplateSvc() {
        return InvokerProxy.instance.create("SysMessageTemplateService", null, connection );
    }

    public def getSenderSvc() {
        return InvokerProxy.instance.create("SysMessageSenderService", null, connection );
    }

    def viewData() {
        def data = dataSvc.getData( [statement: entity.testparams + "\n" + entity.statement, querytype: 'SCRIPT' ] );
        if( data && (data instanceof List)) data = data[0];
        Modal.show("debug:view", [schema:[], data:data]);   
    }

    def testTemplate() {
    	def data = templateSvc.getRender( [ templateid: entity.objid, params: [:], test: true ] );
        if( data && (data instanceof List)) data = data[0];
    	return Inv.lookupOpener("sys_message_template_view", [entity: data ]);  	
    }

    def testSend() {
        senderSvc.send( templateid: entity.objid, params: [:], test: true );
        MsgBox.alert("message sent. Please check in the message queue");    
    }
}