package com.rameses.jasper.models;

import java.net.URL;
import com.rameses.osiris2.reports.*;

class ExtReportTemplateClassLoader extends ClassLoader  {

    private SysReportTemplate template;
    private def templateSvc;
    
    public ExtReportTemplateClassLoader( SysReportTemplate temp, def templateSvc ) {
        this.template = temp; 
        this.templateSvc = templateSvc;
    }
    
    public URL getResource(String name) {
        try {
            if ( template == null ) {
                return null; 
            }
            def res = template.getResource( name );
            if( res == null ) {
                def fpath = name.replace('\\', '/');
                if(!fpath.startsWith("/")) {
                    String cpath = template.getContextPath().replace('\\', '/');
                    if( !cpath.endsWith("/") ) cpath = cpath + "/";
                    fpath = cpath + fpath; 
                }
                def t  = templateSvc.getResource( fpath );
                if( t ) {
                    template.saveContent(name, t.bytes, t.lastmodified);    
                }
                def fi = template.getResource(name);
                return fi.toURI().toURL();
            }
            return res; 
        } 
        catch(RuntimeException re) {
            return null;
        }
        catch(Throwable ex) {
            return null;
        }
    }


}