package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;


public class ViewChangeModel {
    
    //set from outside
    Map oldData;
    Map newData;

    def diffList;

    void buildEntry( String prefix, Map map, def resultList ) {
        map.each { k,v->
            if(k.endsWith("id")) return;
            String fldName = k;
            if( prefix !=null ) fldName = prefix + "." + fldName;
            if( v instanceof Map ) {
                buildEntry( fldName, v, resultList );
            }
            else {
                resultList << [key: fldName, value: v];   
            }
        }
    };

    public void init() {
        if(!oldData) throw new Exception("Please specify old data"); 
        if(!newData) throw new Exception("Please specify new data");  

        def oldKeyValList = [];
        def newKeyValList = [];  

        buildEntry(  null, oldData, oldKeyValList );
        buildEntry(  null, newData, newKeyValList );

        def prevData =  oldKeyValList - newKeyValList;
        def newChanges =  newKeyValList - oldKeyValList;

        diffList = [];
        prevData.each { entry->
            
            def m = [key:entry.key, oldvalue: entry.value ];
            m.newvalue = newChanges.find{ it.key == entry.key }?.value
            diffList << m;
         }
         
    }

    def listModel = [
        fetchList: { o->
            return diffList;
        }
    ] as BasicListModel;
    
    def doClose() {
        return "_close";
    }


}