package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class StatementOfAccountModel {
    
    @Controller
    def workunit;
    
    @Invoker
    def invoker;
    
    @Caller
    def caller;
    
    def billid;
    def entity;
    def serviceName;
    
    public def getService() {
        String conn = workunit.workunit.module?.getProperties().get("connection"); 
        return InvokerProxy.instance.create(serviceName, null, conn );
    }
    
    void init() {
        if(!billid) 
            billid = caller.entity.objid;
    	if(!billid) throw new Exception("Please pass the billid parameter in StatementOfAccountModel");
        serviceName = invoker.properties.serviceName;
    	if(!serviceName) throw new Exception("Please pass the serviceName parameter in StatementOfAccountModel");
        entity = getService().getStatement( [billid: billid ] );
    }
    
    def statementHandler = [
        fetchList: { o->
            //the list must have a column 'total' otherwise this wont work.
            def items = entity.items;
            def runBal = 0;
            items.findAll{it.runbalance==null}.each { v->
                if(!v.total) {
                    v.runbalance = runBal;           
                }
                else {
                    runBal = NumberUtil.round( runBal + v.total );
                    v.runbalance = runBal;
                }    
            }
            return items;
        }
    ] as BasicListModel;
    
}