package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import java.rmi.server.*;
import com.rameses.util.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;

public class ItemAccountModel extends CrudFormModel {
    
    def itemTypes = [
        "MAIN", "SURCHARGE","INTEREST","DISCOUNT", "INSTALLMENT", "DOWNPAYMENT"
    ]
    
    void afterCreate() {
        entity.objid = "";
        entity.allowmanual = 0;
    }
    
    def mapAccount() {
        def p = [:];
    	p.onselect = { o->
            def m = [_schemaname: getSchemaName() ];
            m.item = o;
            m.findBy = [objid: entity.objid];
            persistenceService.update( m );
            open();
            binding.refresh();
    	}
    	return Inv.lookupOpener("revenueitem:lookup", p )
    }

    def unmapAccount() {
        def m = [_schemaname: getSchemaName() ];
        m.item = [objid: "{NULL}", title: "{NULL}", code: "{NULL}"];
        m.findBy = [objid: entity.objid];
        persistenceService.update( m );
        open();
        binding.refresh();
    }
    
}