package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import com.rameses.util.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;

public class InfoVariableModel extends CrudFormModel {
    
    def datatypes = ['integer','decimal','boolean','string','text', 'date', 'array']
    def lookupList;
    def lookupValueHandler;
    
    void initLookupList() {
        def m = [_schemaname: lookupValueHandler ];
        m._limit = 1000;
        m.select = "listname";
        m.groupBy = "listname";
        lookupList = queryService.getList(m)*.listname;
    }
    
    void afterCreate() {
        if( lookupValueHandler ) datatypes << "lookup";
        entity.arrayvalues = [];
        entity.system = 0;
        entity.state = 'DRAFT';
    }
    
    void afterOpen() {
        if( lookupValueHandler ) datatypes << "lookup";
        if(entity.datatype == "lookup") initLookupList();
    }
    
    @PropertyChangeListener
    def listener = [
        "entity.datatype" : { o->
            if( o == "lookup") {
                if(!lookupList) {
                    initLookupList();
                }
                else {
                    entity.lookuplistname = null;
                }
            }
            if( o != 'array' ) {
                entity.arrayvalues = null;
            }
            else {
                entity.arrayvalues = [];
            }
        }
    ];
    
    
    def selectedListItem;
    void addListItem() {
        def r = MsgBox.prompt("Add Item");
        if(!r) return;
        if(entity.arrayvalues==null) entity.arrayvalues = [];
        entity.arrayvalues << r.toUpperCase();
    }
    
    void removeListItem() {
        if(!selectedListItem) return;
        if(entity.arrayvalues==null) entity.arrayvalues = [];        
        entity.arrayvalues.remove( selectedListItem ); 
    }
    
}