package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class DocTypeModel extends CrudFormModel {
    
    public String getConnection() {
        return caller.getConnection();
    }
    
    public boolean isEditAllowed() {
        if( entity.state == 'POSTED') return false;
        return super.isEditAllowed();
    }
    
    def getLookupSignature() {
        return Inv.lookupOpener("sys_signature:lookup", [:] );
    }
    
    def getLookupReport() {
        def h = [
            onselect: { r->
                entity.reportid = r.name;
                binding.refresh();
            }
        ]
        return Inv.lookupOpener("sys_report_def:lookup", h );
    }
    
    def getLookupTemplate() {
        def h = [
            onselect: { r->
                entity.templateid = r.name;
                binding.refresh();
            }
        ]
        return Inv.lookupOpener("sys_report_template:lookup",  h );
    }
    
    def getDocClasses() {
        return ["PRIMARY", "ANCILLARY", "REPORT", "OTHER"];
    }
    
    void approve() {
        if(!MsgBox.confirm("You are about to approve this entry. Data cannot be edited anymore but can only be superseded. Proceed?")) return;
        doAction( 'approve' );
        entity.state = 'POSTED';
    }
    
    void supersede() {
    	def oldEntity = entity;
    	int newver = (oldEntity.version == null) ? 1 : oldEntity.version + 1;
        create();
    	entity.putAll( oldEntity );
        entity.remove("objid");
    	entity.version = newver;
    	entity.supersededid = oldEntity.objid;
    } 
    
    void afterCreate() {
       entity.state = 'DRAFT';
       entity.version = 0;
       entity.sortorder = 0;
       entity.issuetype = 0;
    }
    
    @PropertyChangeListener
    def listener = [
        "entity.name" : { o->
            entity.objid = entity.name;
            if( entity.version ) entity.objid = entity.objid + ":" + entity.version;
            binding.refresh("entity.objid");
        }
    ];
    
    
    def selectedItem;
    
    def fetchItems( def o ) {
        return [];
    }
    
    def itemListHandler = [
        fetchList: {
            return fetchItems([:]);
        }
    ] as BasicListModel;
    
    def addItem() {
        throw new Exception("addItem not supported");
    }
    
    def removeItem() {
        throw new Exception("removeItem not supported");
    }
    
}