package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class AppInitialModel  {
    
    @Service("QueryService")
    def querySvc;

    @Controller
    def workunit;

    @Invoker
    def invoker;

    def entity;
    def trackingno;
    def source = "web";
    def txnmode = "CAPTURE";
    def txnModes = ["ONLINE", "CAPTURE"];

    def taskstate;
    def taskStates;
    def serviceName;

    def pageMode = "initial";

    public String getPageName() {
        return pageMode;
    }

    public String getSchemaName() {
        return workunit?.info?.workunit_properties?.schemaName;
    }
    
    public String getEntitySchemaName() {
        def _entitySchemaName = workunit?.info?.workunit_properties?.entitySchemaName;
        if(!_entitySchemaName) {
        	_entitySchemaName = schemaName;
        }
        return _entitySchemaName;
    }

    public String getProcessname() {
        def _procName = workunit?.info?.workunit_properties?.processName;
        if(!_procName) {
            _procName = entitySchemaName;
        }
        return _procName;
    }

    public String getConnection() {
  		return workunit?.workunit?.module?.properties?.connection;
    }   

    @FormTitle
    public String getTitle() {
        return invoker.properties.caption;
    }  	

    public String getAppType() {
        return invoker.properties.apptype;    
    }

    public def getAppService() {
        return InvokerProxy.instance.create(serviceName, null, getConnection() );
    }

    def init() {
        serviceName = workunit?.info?.workunit_properties?.serviceName;
        if(!serviceName) throw new Exception("Please specify serviceName in workunit");

    	//build task States
    	def m = [_schemaname: "sys_wf_node"];
    	m.select = "name";
        m.where = [ "processname = :procname AND name NOT IN ('start','end') AND tracktime=1", [procname: entitySchemaName]  ];
        m.orderBy = "idx";
        taskStates = querySvc.getList( m )*.name + ["end"];
        pageMode =  "initial"
        return pageMode;
    }
    
    def back() {
        pageMode = "initial";
        return pageMode;
    }

    public void afterCreate() {;}

    def next() {
	   if(source==null) source = "web";
        if(source.matches("web|local")) {
            def v = appService.getOnlineApplication( [trackingno: trackingno, _schemaname: entitySchemaName ]  );
            if(!MsgBox.confirm("You are about to upload this application. Proceed?")) {
                return null;
            };
            v.txnmode = "ONLINE";
            v._schemaname = getEntitySchemaName();
            v = appService.create( v );
            def entity = [objid: v.objid ];            
            def op = Inv.lookupOpener( schemaName + ":open", [entity:entity] );  
            op.target = "self";
            return op;
        }
        else if( source == "capture") {
            entity = [:];
            entity.task = [state:taskstate];
            entity.txnmode = "CAPTURE";
            entity.apptype = appType;
            afterCreate();
            pageMode = "default";
            return pageMode;
        }
        else {
            throw new Exception("File option not yet accepted!");
        }
    }

    def save() {
        if( !MsgBox.confirm("You are about to save this record. Proceed?") )  return;
        entity._schemaname = getEntitySchemaName();
        entity.processname = getProcessname();
        appService.create( entity );
        if( MsgBox.confirm( "Application successfully saved. Add another? ")) {
            taskstate = null;
            pageMode = "initial";
            return pageMode;    
        }
        else {
            return "_close"; 
        }
    }
    
}