package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;


class AddressEditorModel  {
    
    @Binding
    def binding;
    
    boolean showLocalOption;
    def handler;
    def entity;
    
    void init() {
        if( !entity.barangay ) {
            entity.barangay = [:];
        }
    }
    
    
    @PropertyChangeListener
    def listener  = [
        "entity.barangay" : { o->
            entity.citymunicipality = o.parent?.name;
            entity.province = o.province;
            binding.refresh();
        },
        "entity.local" :{ o->
            if(o==0) {
                entity.citymunicipality = "";
                entity.province = ""; 
                entity.barangay = [:];                    
            }
            binding.refresh();
        }
    ];

    public boolean getLocal() {
        return (entity.type == 0);
    }
    
    def buildAddress() {
        def list = [];
        list << [ entity.unitno, entity.bldgno, entity.bldgname ].findAll{ it }.join(" ");
        list << [ entity.blockno, entity.lotno, entity.street ].findAll{ it}.join(" ");
        list << [ entity.subdivision, entity.barangay?.name].findAll{ it }.join(", ");
        list << [ entity.citymunicipality, entity.province].findAll{ it }.join(", ");
        entity.text = list.findAll{ it }.join( "\n" );
        return entity;
    }
    
    def doOk() {
        handler( buildAddress() );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
}