package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;


public abstract class AbstractBillPaymentListModel {
    
    @Binding 
    def binding;

    @Invoker
    def invoker;

    @Caller
    def caller;

    def selectedPayment;
    
    def items;
    
    public abstract def fetchList(def m);
    public abstract def getPaymentInfo( def o );
    
    public void afterUpdateItems() {
        //place code here to refresh bill
    }

    public void removePayment(def item) {
        throw new Exception("Override removePayment(item) method");
    }

    public void postPayment(def item) {
        throw new Exception("Override postPayment(item) method");
    }

    public def viewPayment( def item ) {
        throw new Exception("Override viewPayment(item) method");
    }

    public void init() {
        //do nothing
    }
    
    boolean getAllowCapturePayment() {
        return true;
    }

    boolean getAllowVoidPayment() {
        return true;
    }
    
    void reload() {
        pmtListHandler.reload();
        afterUpdateItems();
    }

    def pmtHandler = [
        getPaymentItems: { o->
            def res = getPaymentInfo( o );
            if(!res.billitems) throw new Exception("Please return billitems list from getPaymentInfo");
            return res.billitems;
        },
        getReceiptItems: { o->
            def res = getPaymentInfo( o );
            if(!res.items) throw new Exception("Please return items list from getPaymentInfo");
            return [items: res.items]; 
        },
        postPayment: { o->
            def res = getPaymentInfo( o );
            if(!res.postingitems) throw new Exception("Please return postingitems list from getPaymentInfo");
            o.postingitems = res.postingitems; 
            postPayment( o );
            reload();
        }
    ];

    def pmtListHandler = [
        fetchList: { o->
            items = fetchList(o);
            return items;
        }
    ] as BasicListModel;
    
    def addPayment() {
        return Inv.lookupOpener("capture_single_bill_payment", [handler: pmtHandler ] );
    }
    
    //use this when calling items
    public void deletePayment() {
        removePayment();
    }

    void removePayment() {
        if(!selectedPayment) return;
        if(selectedPayment.txnmode != 'CAPTURE') {
            throw new Exception("Only payments in CAPTURE mode can be deleted");
        };
        removePayment( selectedPayment );
        reload();
    }
    
    def viewPayment() {
        if(!selectedPayment) throw new Exception("Please select payment");
        return viewPayment(selectedPayment);
    }
    
    

}