package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;


public abstract class AbstractBillModel extends CrudFormModel {
    
    @Service("SysReportService")
    def reportSvc;
    
    public abstract def getBillingService();
    
    def create() {
        entity = billingService.create( [txnid: caller.entity.objid]);
        caller.entity.billid = entity.objid;
        caller.binding.refresh();
        mode = "read";
        return null;
    }
    
    def open() {
        entity = [objid: caller.entity.billid];
        super.open();
        return null;
    }

    def cancelBill() {
        if(!MsgBox.confirm("You are about to cancel this bill. Proceed?")) return;
        billingService.cancelBill( [billid: entity.objid ] );
        caller.entity.billid = null;
        caller.binding.refresh();
        return "_close";
    }

    def showReport( def p ) {
        def m = [:];
        m.query = [objid: entity.objid];
        m.reportDef = p;
        m.connection = getConnection();
        m.title = p.title;
        return Inv.lookupOpener( "sys_report_form", m );
    }

    def viewReport() {
        def category = entitySchemaName + ":form:reports";
        def opMenu = new PopupMenuOpener();
        try {
            def list = reportSvc.getListByCategory([ category: category ] );
            list.each {
                opMenu.add( new PopupAction(name:"showReport", caption:it.title, parameters: it, obj: this ) );      
            }
        } 
        catch(Throwable ign){;}
        if(opMenu.items.size()==0) throw new Exception("No reports defined in category in " + category);
        return opMenu;    
    }

    def post() {
        billingService.post( [billid: entity.objid ] );
        entity.state = 'POSTED';
        binding.refresh();
    } 

    def unpost() {
        billingService.unpost( [billid: entity.objid ] );
        entity.state = 'OPEN';
        binding.refresh();
    } 

    public void reloadBill() {
        reloadEntity();
    }

}