package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

public abstract class AbstractBillItemListModel {
 
    @Caller
    def caller;

    @Invoker
    def invoker;

    @Binding
    def binding;

    boolean allowRules = true;
    boolean allowAdd = true;
    boolean allowEdit = true;
    boolean allowRemove = true;
    
    def totals = 0;


    boolean inited = false;
    def internalList;
    
    def viewtype = "all";
    
    def selectedItem;
    
    //overridable actions
    public abstract def fetchList(def o);
    
    
    public void doClearItems() {
        throw new Exception("Please override doClearItems method" );
    }
    public def executeRules() {
        throw new Exception("Please override executeRules method" );    
    }
    public void doAddItems( def items ) {
        throw new Exception("Please override doAddItems(List) method" );    
    }
    public def getLookpItemHandler() {
        throw new Exception("Please override getLookupItemHandler method");    
    }
    public void doRemoveItem( def item ) {
        throw new Exception("Please override doRemoveItem(Item) method" );    
    }
    
    public void afterUpdateItems() {
        //place code here to refresh bill
    }
    
    public void afterInit() {
        //do something here
    }

    @PropertyChangeListener
    def listener = [
        "viewtype" : { o->
            internalList = null;
            listHandler.reload();
        }
    ]
    
    boolean getShowItemActions() {
        return true;
    }

    public void init() {
       updateTotals();
       afterInit();
    }
    
    def listHandler = [
        fetchList: { o->
            return getListValue();
        }
    ] as BasicListModel;
    
    public def getListValue() {
        if(internalList!=null) return internalList;
        def m = [:];
        m.viewtype = viewtype;
        internalList = fetchList(m);
        if(internalList==null) internalList = [];
        return internalList;
    }
    
    void updateTotals() {
        totals = NumberUtil.round( listValue.sum{it.balance} );
    }
    
    void assess() {
        def items = null;
        try {
            items = executeRules();
        }
        catch(BreakException be) {
            return;
        }
        catch(e) {
            throw e;
        }
        if(items) {
            def p = [:];
            p.onselect = { o->
                items.each{ 
                    it.auto = true; 
                } 
                doAddItems( items );
                reload(); 
            };
            p.listHandler = [
                getColumns: {
                    return listHandler.getColumns(); 
                },
                fetchList: {
                    return items;
                }
            ] as BasicListModel;
            p.title = "Please check before accepting assessment";
            Modal.show( "simple_list_lookup", p, [width:800, title:"Verify Assessment"] );    
        };
        else {
            reload();
            return;
        }
    }
    
    def addItem(){
        def p = [:];
        p.saveHandler = { o->
            o.auto = false;
            o.itemid = o.item.objid;
            doAddItems( [o] );
            reload();
        };
        p.lookupHandler = getLookupItemHandler();
        Modal.show( "app_common:addbillitem", p );
        return null;
    }
    
    void removeItem() {
        if(!selectedItem) throw new Exception("Please select item first");
        doRemoveItem( selectedItem );
        reload();
    }
    
    void editItem() {
        throw new Exception("Edit billitem not yet supported");
    }
    
    void clearItems() {
        doClearItems();
        reload();
    }
    
    void reload() {
        internalList = null;
        listHandler.reload();  
        updateTotals();
        binding.refresh("totals");
        afterUpdateItems();    
    }
    
    
    
}