package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class BillItemListComponentModel extends ComponentBean {

    boolean allowRules = true;
    boolean allowAdd = true;
    boolean allowEdit = true;
    boolean allowRemove = true;
    boolean showItemActions = true;
    
    def options;
    def lookupHandler;
    def handler;
    def totals = 0;

    boolean inited = false;
    def internalList;
    
    def viewtype = "all";
    
    def selectedItem;
    
    @PropertyChangeListener
    def listener = [
        "viewtype" : { o->
            internalList = null;
            listHandler.reload();
        }
    ]
    
    public void init() {
        if(handler) {
            handler.reload = {
                internalList = null;
                listHandler.reload();
                updateTotals();
                binding.refresh("totals");
            }
        };
        updateTotals();
    }
    
    def listHandler = [
        fetchList: { o->
            return getListValue();
        }
    ] as BasicListModel;
    
    public def getListValue() {
        if(internalList!=null) return internalList;
        def m = [:];
        m.viewtype = viewtype;
        internalList = handler.fetchList(m);
        if(internalList==null) internalList = [];
        return internalList;
    }
    
    void updateTotals() {
        totals = NumberUtil.round( listValue.sum{it.balance} );
    }
    
    void assess() {
        if(!handler) throw new Exception("handler is required for execRules");
        def items = null;
        try {
            items = handler.executeRules();
        }
        catch(BreakException be) {
            return;
        }
        catch(e) {
            throw e;
        }
        if(items) {
            def p = [:];
            p.onselect = { o->
                items.each{ 
                    it.auto = true; 
                } 
                handler.addItems( items );
                internalList = null;
                listHandler.reload();
                 
            };
            p.listHandler = [
                getColumns: {
                    return listHandler.getColumns(); 
                },
                fetchList: {
                    return items;
                }
            ] as BasicListModel;
            p.title = "Please check before accepting assessment";
            Modal.show( "simple_list_lookup", p, [width:800, title:"Verify Assessment"] );    
        };
        else {
            internalList = null;
            listHandler.reload();
            updateTotals();
            binding.refresh("totals"); 
            return;
        }
    }
    
    def addItem(){
        if(!handler.lookupAccount) 
            throw new Exception("Please specify lookupAccount in the handler");
        def p = [:];
        p.saveHandler = { o->
            o.auto = false;
            o.itemid = o.item.objid;
            handler.addItems( o );
            internalList = null;
            listHandler.reload();
            updateTotals();
            binding.refresh("totals");
        };
        p.lookupHandler = handler.lookupAccount;
        /*
        p.lookupHandler = {
            def q = [:];
            q.query = [doctypeid: caller.entity.doctypeid ];
            return Inv.lookupOpener(lookupHandler, q);
        }
        */
        if( handler.options) p.putAll(handler.options);
        Modal.show( "app_common:addbillitem", p );
    }
    
    void removeItem() {
        if(!selectedItem) throw new Exception("Please select item first");
        if(handler) handler.removeItems( [selectedItem] );
        listHandler.reload();  
        updateTotals();
        binding.refresh("totals");
    }
    
    void editItem() {
        throw new Exception("Edit billitem not yet supported");
    }
    
    void clearItems() {
        if(handler) handler.clearItems(); 
        internalList = null;
        listHandler.reload();  
        updateTotals();
        binding.refresh("totals");   
    }
    
    
}
