package com.rameses.gov.etracs.obo.cloud.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CloudRequirementsModel {

    @Service("CloudOboAppService")
    def appSvc;

    def mode = "update";
    def entity;
    
    def oldtext;
    
    void init(def inv) {
        def apptype = inv.properties.apptype;
        entity = appSvc.findRequirementText( [apptype: apptype] );
        if(!entity ) {
            if(!MsgBox.confirm("Requirements not found. Create New?")) {
                throw new BreakException();
            }
            def tmp = appSvc.findRequirementDefaultText( [apptype: apptype] );
            def entity = [:];
            entity.objid = ((apptype == "building" ) ? "BP" : "OC") + "R"+ tmp.orgcode;
            entity.apptype = apptype; 
            entity.orgcode = tmp.orgcode; 
            entity.text = tmp?.text; 
            mode = "create";     
        }
        oldtext = entity.text;
    }
    
    def getHtml() {
        return entity.text;
    }
    
    def doCancel() {
        if(oldtext!=entity.text) {
            if(!MsgBox.confirm("Cancel without saving changes?")) return null;
        }
        return "_close";
    }
    
    def doOk() {
        if(!MsgBox.confirm("You are about to publish these changes. Continue?")) return null;
        if( mode == "create" ) {
            appSvc.createRequirementText( entity );
        }
        else {
            appSvc.updateRequirementText( entity );
        }
        return "_close";
    }
    
}