package com.rameses.gov.etracs.obo.cloud.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CloudOboProfessionalListModel extends CrudListModel {

    @Service("CloudOboAppService")
    def appSvc;

    def filter = "local";

    @PropertyChangeListener
    def listener = [
        "filter" : { o->
            reload();
        }
    ]
    
    public List getShowitems() {
        return [
           [id:"local", title: "Local"],
           [id:"global", title: "Global"]
        ]
    }

    void init() {}

    boolean allowSearch = true;

    public def getColumnList() {
        return [
            [name:'prc.idno', caption: 'PRC No'],
            [name:'profession', caption: 'Profession'],
            [name:'prc.dtissued', caption: 'PRC Date Issued'],
            [name:'lastname', caption: 'Last Name'],
            [name:'firstname', caption: 'First Name'],
            [name:'address.text', caption: 'Address'],
        ]
    }          

    public def fetchList( o ) {
        o.scope = filter;
        return appSvc.getProfessionalList( o );
    }
    
}