package com.rameses.gov.etracs.obo.cloud.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CloudOboCrudListModel extends CrudListModel {

    @Service("CloudOboAppService")
    def appSvc;

    void init() {}

    boolean allowSearch = true;

    public def getNodeList() {
        return [
            [state:"ongoing", title:"Ongoing"],
            [state:"completed", title:"Submitted"]            
        ];
    }

    public def getColumnList() {
        return [
            [name:'objid', caption: 'Tracking No'],
            [name:'title', caption: 'Title'],
            [name:'applicant.name', caption: 'Applicant Name'],
            [name:'step', caption: 'Step'],
            [name:'state', caption: 'State'],
        ]
    }          

    public def fetchList( o ) {
        o._schemaname = schemaName;
        o.state = selectedNode.state;
        return appSvc.getApplicationList( o );
    }

    public void returnToApplicant() {
        if(!selectedItem) throw new Exception("Please select an item first");
        if(!selectedItem.state?.equalsIgnoreCase("end")) 
            throw new Exception("You cannot send this because this application has not yet ended");
        appSvc.returnToApplicant( [_schemaname: schemaName, objid:selectedItem.objid, step: selectedItem.step ] );
        reload();
    }


}