package com.rameses.gov.etracs.obo.building.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.gov.etracs.obo.models.*;

class BuildingPermitRpuListModel extends AppFormSectionListModel  {
    
    @Service("BuildingPermitRpuService")
    def rptService;
    
    @Service("Var")
    def varSvc;
    
    String schemaName = "building_permit_rpu";
    

    String getEditState() {
        return invoker.properties.editState;
    }

    boolean getCanEdit() {
        if( formContext == "application" ) {
            if( task.tracktime != 1 ) return false;
            if( editState && appState.matches( editState ) ) {
                return isTaskAssignee();
            }
            else {
                return hasRole( "COORDINATOR" );
            }    
        }
        else if( formContext == "taskitem" ) {
            return isTaskAssignee();
        }
        return false;
    } 

    public boolean getAllowGenerateDocs() {
        def r = varSvc.get("allow_generate_rpt_docs");
        if( r == null ) return true;
        if( r == "false") {
            return false;
        }
        else {
            return true;
        }
    }
    
    boolean getEditable() {
        return true;
    }

    public def fetchList( def  o ) {
        def m = [_schemaname: schemaName ];
        m.findBy = [appid: entity.objid];
        return queryService.getList( m ); 
    }

     //Generate Docs
    void generateDocs() {
        def m = [appid: entity.objid]; 
        rptService.generateDocs( m );
        refresh();
        MsgBox.alert("RPT Docs generated successfully");
    }
    
    def viewTaxClearance() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(!selectedItem.taxclearanceid ) throw new Exception("Tax clearance not yet generated");
        return Inv.lookupOpener( 'rpttaxclearance:view', [entity: [objid: selectedItem.taxclearanceid ]] );
    }
    
    def viewTrueCopy() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(!selectedItem.truecopycertid ) throw new Exception("Clearance not yet generated");
        return Inv.lookupOpener( 'tdtruecopy:view', [entity: [objid: selectedItem.truecopycertid ]] );
    }
    
    def addItem() {
        def h = [:];
        h.appid = entity.objid;
        h.handler = {
            refresh();
        }
        return Inv.lookupOpener( "building_permit_rpu:create", h );
    }
    
    def viewItem(def sitem) {
        def h = [:];
        h.appid = entity.objid;
        h.entity = sitem;
        h.editable = canEdit;
        h.handler = {
            refresh();
        }
        return Inv.lookupOpener( "building_permit_rpu:open", h );        
    }
    
    void removeItem(def sitem) {
        def m = [_schemaname: "building_permit_rpu"]
        m.objid = selectedItem.objid;
        persistenceService.removeEntity( m );
    }
    
    void updateInfo() {
        rptService.updateRpuInfo([appid: entity.objid] )
    }
    
}
