package com.rameses.filemgmt.impl;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.filemgmt.FileLocationProvider;

class FileLocationProviderImpl implements FileLocationProvider {
    
    @Service( dynamic = true )
    def dynaSvc; 

    Map getDefaultLocation( String connection ) {
        def appEnv = ClientContext.getCurrentContext().getAppEnv(); 
        def keyName = [ connection, "filemgmt.connection" ].findAll{ it }.join("."); 
        def connFileName = appEnv.get( keyName );
        if( connFileName != null && connFileName.trim().length() > 0 ) {
            
            def m = [_schemaname: 'sys_fileloc', findBy: [objid: connFileName]]; 
            def svc = dynaSvc.lookup('PersistenceService', connection ); 
            def o = svc.read( m ); 
            if ( o ) {
                resolveData( o ); 
                return o; 
            }
            
            def sysfileSvc = dynaSvc.lookup( 'SysFileService', connection ); 
            def connMap = sysfileSvc.getConnection( connFileName.trim()); 
            connMap.objid = connFileName.trim();
            connMap.loctype = connMap.type;
            connMap.defaultloc = 1; 
            resolveData( connMap );
            return connMap;
        }
        
        def m = [_schemaname: 'sys_fileloc', findBy: [defaultloc: 1]]; 
        def svc = dynaSvc.lookup('PersistenceService', connection ); 
        def o = svc.read( m ); 
        resolveData( o ); 
        return o; 
    }

    Map getLocation( String connection, String locationId ) {
        def m = [_schemaname: 'sys_fileloc', findBy: [objid: locationId]]; 
        def svc = dynaSvc.lookup('PersistenceService', connection ); 
        def o = svc.read( m ); 
        if ( o ) {
            resolveData( o ); 
            return o; 
        }
        
        def sysfileSvc = dynaSvc.lookup( 'SysFileService', connection ); 
        def map = sysfileSvc.getConnection( locationId ); 
        map.objid = locationId; 
        map.loctype = map.type;
        map.defaultloc = 1; 
        resolveData( map );
        return map;
    }
    
    public List getLocations( String connection ) {
        def list = null; 
        try { 
            def m = [ _schemaname: 'sys_fileloc', where:[' 1=1 ']]; 
            def svc = dynaSvc.lookup('QueryService', connection ); 
            list = svc.getList( m ); 
        } catch(Throwable t) {
            list = []; 
        } 

        list.each{ resolveData(it) } 
        return list; 
    } 
    
    void resolveData( o ) {
        if ( !o ) return; 
        
        if ( !o.name ) o.name = o.objid;
        if ( !o.type ) o.type = o.loctype; 
        if ( !o.username ) o.username = o.user?.name;
        if ( !o.password ) o.password = o.user?.pwd; 
        
        o.defaulted = false; 
        if ( o.defaultloc ) {
            o.defaulted = (o.defaultloc.toString().matches('1|true')); 
        }
    }
}