package com.rameses.admin.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
         
public class UserGroupMgmtModel {
    
    @Service("QueryService")
    def qrySvc;

    @Binding
    def binding;
    
    def domain;
    def domainList;
    def _roleHandlerMap = [:];
    
    def closeHandler = {
        if ( binding ) { 
            binding.fireNavigation('_close'); 
        }
    }
    
    void init() {
        def m = [_schemaname: "sys_domain"];
        m.where = ["1=1"];
        domainList = [[name: "MAIN"]] + qrySvc.getList( m );
        domain = domainList[0];
    }
    
    public def getRoleHandler() {
        def dname = domain.name.toLowerCase();
        if ( !_roleHandlerMap.containsKey( dname )) { 
            def param = [ closeHandler: closeHandler ]; 
            String hname = "sys_role_list";
            if(dname == "main") {
                hname = hname + ":main";
            }
            else {
                param.connection = domain.connection;
            }
            def inv = Inv.lookupOpener( hname, param ); 
            _roleHandlerMap.put( dname, inv );
        }
        return _roleHandlerMap.get( dname );
    }
}


        