/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.sigid.device;

import com.rameses.rcp.common.SigIdResult;
import com.rameses.rcp.sigid.SigIdParams;
import com.topaz.sigplus.SigPlus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

class TopazPanel
extends JPanel {
    private JPanel toolbar;
    private SigPlus sigplus;
    private Repainter repainter;
    private SigIdParams params;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public TopazPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.repainter = new Repainter();
        this.sigplus = new SigPlus();
        this.add((Component)this.sigplus);
        Border bout = BorderFactory.createEtchedBorder();
        Border bin = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.toolbar = new JPanel(new BorderLayout());
        this.toolbar.setBorder(BorderFactory.createCompoundBorder(bout, bin));
        this.add((Component)this.toolbar, "South");
        JPanel leftSection = new JPanel();
        JButton btnClear = new JButton(" Clear ");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopazPanel.this.onclearTablet();
            }
        });
        leftSection.add(btnClear);
        this.toolbar.add((Component)leftSection, "West");
        JPanel rightSection = new JPanel();
        JButton btnOK = new JButton("   OK   ");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopazPanel.this.onselect();
            }
        });
        rightSection.add(btnOK);
        JButton btnCancel = new JButton(" Cancel ");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopazPanel.this.oncancel();
            }
        });
        rightSection.add(btnCancel);
        this.toolbar.add((Component)rightSection, "East");
    }

    void start() {
        String keystr;
        this.sigplus.setTabletModel("SignatureGem1X5");
        this.sigplus.setTabletComPort("HID1");
        this.sigplus.clearTablet();
        String string = keystr = this.params == null ? null : this.params.getKey();
        if (keystr != null && keystr.trim().length() > 0) {
            this.sigplus.setKeyString(keystr);
        }
        this.sigplus.setTabletState(0);
        this.sigplus.setTabletState(1);
        this.repainter.start();
    }

    void stop() {
        int imgysize;
        int imgxsize;
        int pensize;
        int n = pensize = this.params == null ? 0 : this.params.getPenWidth();
        if (pensize <= 0) {
            pensize = 8;
        }
        int n2 = imgxsize = this.params == null ? 0 : this.params.getImageXSize();
        if (imgxsize <= 0) {
            imgxsize = 1000;
        }
        int n3 = imgysize = this.params == null ? 0 : this.params.getImageYSize();
        if (imgysize <= 0) {
            imgysize = 350;
        }
        this.sigplus.setTabletState(0);
        this.sigplus.setImagePenWidth((float)pensize);
        this.sigplus.setImageXSize(imgxsize);
        this.sigplus.setImageYSize(imgysize);
        this.repainter.stop();
    }

    void fireOnclose() {
        for (SelectionListener sl : this.listeners) {
            sl.onclose();
        }
    }

    public void setParams(SigIdParams params) {
        this.params = params;
    }

    private void onclearTablet() {
        this.sigplus.clearTablet();
    }

    private void onselect() {
        this.stop();
        SigInfoImpl siginfo = new SigInfoImpl();
        siginfo.sigString = this.sigplus.getSigString();
        siginfo.keyReceipt = this.sigplus.getKeyReceipt();
        siginfo.keyString = this.sigplus.getKeyString();
        siginfo.numOfStrokes = this.sigplus.getNumberOfStrokes();
        siginfo.sigImage = this.sigplus.sigImage();
        for (SelectionListener sl : this.listeners) {
            sl.onselect(siginfo);
        }
        this.fireOnclose();
    }

    private void oncancel() {
        this.stop();
        this.fireOnclose();
    }

    public void remove(SelectionListener sl) {
        if (sl != null) {
            this.listeners.remove(sl);
        }
    }

    public void add(SelectionListener sl) {
        if (sl != null && !this.listeners.contains(sl)) {
            this.listeners.add(sl);
        }
    }

    private class SigInfoImpl
    implements SigIdResult {
        private BufferedImage sigImage;
        private byte[] imageData;
        private String sigString;
        private String keyString;
        private int keyReceipt;
        private int numOfStrokes;

        private SigInfoImpl() {
        }

        @Override
        public String getSigString() {
            return this.sigString;
        }

        @Override
        public String getKeyString() {
            return this.keyString;
        }

        @Override
        public int getKeyReceipt() {
            return this.keyReceipt;
        }

        @Override
        public int getNumberOfStrokes() {
            return this.numOfStrokes;
        }

        @Override
        public byte[] getImageData() {
            if (this.sigImage == null) {
                return null;
            }
            if (this.imageData == null) {
                int w = this.sigImage.getWidth(null);
                int h = this.sigImage.getHeight(null);
                int[] pixels = new int[w * h * 2];
                this.sigImage.setRGB(0, 0, 0, 0, pixels, 0, 0);
                ByteArrayOutputStream fos = null;
                try {
                    fos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)this.sigImage, "JPG", fos);
                    byte[] byArray = fos.toByteArray();
                    return byArray;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return this.imageData;
        }

        @Override
        public void dump() {
            System.out.println("keyReceipt=" + this.keyReceipt);
            System.out.println("numOfStrokes=" + this.numOfStrokes);
            System.out.println("keyString=" + this.keyString);
            System.out.println("sigString=" + this.sigString);
            System.out.println("imageData=" + this.getImageData());
        }
    }

    public static interface SelectionListener {
        public void onselect(SigIdResult var1);

        public void onclose();
    }

    private class ToolbarLayout
    implements LayoutManager {
        TopazPanel root;

        private ToolbarLayout() {
            this.root = TopazPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + 3;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
            }
        }
    }

    private class Repainter {
        TopazPanel root;
        boolean started;
        boolean cancelled;

        private Repainter() {
            this.root = TopazPanel.this;
        }

        void start() {
            if (this.started) {
                return;
            }
            this.started = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Repainter.this.runImpl();
                }
            };
            new Thread(runnable).start();
        }

        void stop() {
            this.cancelled = true;
        }

        private void runImpl() {
            while (!this.cancelled) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Repainter.this.root.sigplus.repaint();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            this.started = false;
            this.cancelled = false;
        }
    }
}

