/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.image;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.ImageModel;
import com.rameses.rcp.image.ContentPane;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class ImageViewer {
    private Map options;
    private ImageModel model;
    private int width;
    private int height;
    private boolean autoOpenMode;
    private JFileChooser fileChooser;

    public static void open(Map options) {
        new ImageViewer(options).open();
    }

    public static void open(ImageModel model) {
        new ImageViewer(model).open();
    }

    public ImageViewer() {
        this(new ImageModel());
    }

    public ImageViewer(ImageModel model) {
        this.model = model == null ? new ImageModel() : model;
    }

    public ImageViewer(Map options) {
        this.model = new ImageModelProxy(options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] open() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        ContentPane panel = new ContentPane();
        Object imageData = this.model.getData();
        if (imageData == null) {
            JFileChooser fc = this.getFileChooser();
            fc.addChoosableFileFilter(new ImageFileFilter(this.model));
            int retopt = fc.showOpenDialog(win);
            if (retopt != 0) return null;
            panel.setData(fc.getSelectedFile());
        } else {
            panel.setData(imageData);
        }
        JDialog dialog = null;
        dialog = win instanceof Frame ? new JDialog((Frame)win) : (win instanceof Dialog ? new JDialog((Dialog)win) : new JDialog());
        final JDialog jdialog = dialog;
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setContentPane(panel);
        dialog.setTitle(this.model.getTitle());
        dialog.setSize(this.model.getWidth(), this.model.getHeight());
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.centerWindow(dialog);
        dialog.setVisible(true);
        return null;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private void centerWindow(Window win) {
        Dimension windim = win.getSize();
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(win.getGraphicsConfiguration());
        int scrwidth = scrdim.width - (margin.left + margin.right);
        int scrheight = scrdim.height - (margin.top + margin.bottom);
        int x = Math.max((scrwidth - windim.width) / 2, 0) + margin.left;
        int y = Math.max((scrheight - windim.height) / 2, 0) + margin.top;
        win.setLocation(x, y);
    }

    private class ImageFileFilter
    extends FileFilter {
        private ImageModel model;
        private String filterDescription;

        ImageFileFilter(ImageModel model) {
            this.model = model;
            this.filterDescription = model.getFilterDescription();
            if (this.filterDescription == null || this.filterDescription.length() == 0) {
                this.filterDescription = "*.jpg|*.png|*.gif";
            }
        }

        @Override
        public String getDescription() {
            return this.model.getFilterDescription();
        }

        @Override
        public boolean accept(File file) {
            return this.model.accept(file);
        }
    }

    private class ImageModelProxy
    extends ImageModel {
        private Map options;
        private String title;
        private Integer width;
        private Integer height;
        private CallbackHandlerProxy onselectCallback;
        private CallbackHandlerProxy oncloseCallback;

        ImageModelProxy(Map options) {
            this.options = options;
            this.title = this.getString(options, "title");
            this.width = this.getInt(options, "width");
            this.height = this.getInt(options, "height");
            Object source = this.get(options, "onselect");
            if (source != null) {
                this.onselectCallback = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseCallback = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                return super.getTitle();
            }
            return this.title;
        }

        @Override
        public int getWidth() {
            if (this.width == null) {
                return super.getWidth();
            }
            return this.width;
        }

        @Override
        public int getHeight() {
            if (this.height == null) {
                return super.getHeight();
            }
            return this.height;
        }

        @Override
        public Object getData() {
            Object o = this.get(this.options, "data");
            return o == null ? super.getData() : o;
        }

        public void onselect(Object result) {
            if (this.onselectCallback == null) {
                return;
            }
            this.onselectCallback.call(result);
        }

        public void onclose() {
            if (this.oncloseCallback == null) {
                return;
            }
            this.oncloseCallback.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }
}

