/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class ImageCanvas
extends JLabel {
    private Dimension cropSize;
    private ImageIcon iicon;
    private int iconWidth;
    private int iconHeight;
    private BufferedImage bufferedImage;
    private Point dragPoint;
    private Rectangle rectOver;
    private Point imagePoint;

    public ImageCanvas() {
        super("Image Canvas");
        MouseSupport mouseSupport = new MouseSupport();
        this.addMouseListener(mouseSupport);
        this.addMouseMotionListener(mouseSupport);
        this.addMouseWheelListener(mouseSupport);
        this.addComponentListener(new ComponentListenerImpl());
        this.cropSize = new Dimension(2, 2);
    }

    public void setData(Object data) {
        if (data == null) {
            this.iicon = null;
        } else if (data instanceof File) {
            File file = (File)data;
            this.iicon = new ImageIcon(file.getAbsolutePath());
        } else if (data instanceof URL) {
            URL url = (URL)data;
            this.iicon = new ImageIcon(url);
        } else {
            this.iicon = new ImageIcon((byte[])data);
        }
        this.bufferedImage = null;
        this.iconWidth = this.iicon == null ? 0 : this.iicon.getIconWidth();
        this.iconHeight = this.iicon == null ? 0 : this.iicon.getIconHeight();
    }

    private BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            Image image;
            Image image2 = image = this.iicon == null ? null : this.iicon.getImage();
            if (image == null) {
                return null;
            }
            this.bufferedImage = new BufferedImage(this.iicon.getIconWidth(), this.iicon.getIconHeight(), 2);
            Graphics2D g2 = this.bufferedImage.createGraphics();
            g2.drawImage(image, 0, 0, null);
        }
        return this.bufferedImage;
    }

    private BufferedImage createBufferedImage(double ratio) {
        BufferedImage bi = null;
        if (this.iicon != null) {
            int nw = (int)((double)this.iicon.getIconWidth() * ratio);
            int nh = (int)((double)this.iicon.getIconHeight() * ratio);
            bi = new BufferedImage(nw, nh, 2);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(this.iicon.getImage(), 0, 0, nw, nh, null);
            this.iconWidth = nw;
            this.iconHeight = nh;
        } else {
            this.iconWidth = 0;
            this.iconHeight = 0;
        }
        this.bufferedImage = bi;
        return bi;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle clip = g.getClipBounds();
        g.clearRect(0, 0, width, height);
        int sx = 0;
        int sy = 0;
        BufferedImage bic = new BufferedImage(width, height, 2);
        BufferedImage bi = this.getBufferedImage();
        if (bi != null) {
            sx = (width - this.iconWidth) / 2;
            sy = (height - this.iconHeight) / 2;
            Graphics2D g2b = bic.createGraphics();
            g2b.drawImage((Image)bi, sx, sy, null);
            g2b.dispose();
        }
        this.imagePoint = new Point(sx, sy);
        g.drawImage(bic, 0, 0, null);
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(0.63f);
        Composite oldComposite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(Color.BLACK);
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(oldComposite);
        g2.setColor(oldColor);
        if (bi != null) {
            int cx = 0;
            int cy = 0;
            int cw = this.cropSize.width * 72;
            int ch = this.cropSize.height * 72;
            if (this.rectOver == null) {
                cx = Math.max((width - cw) / 2, 0);
                cy = Math.max((height - ch) / 2, 0);
                this.rectOver = new Rectangle(cx, cy, cw, ch);
            } else {
                cx = this.rectOver.x;
                cy = this.rectOver.y;
            }
            int bw = this.rectOver.width;
            int bh = this.rectOver.height;
            Graphics2D g3 = (Graphics2D)g2.create(cx, cy, cw, ch);
            BufferedImage img3 = bic.getSubimage(this.rectOver.x, this.rectOver.y, bw, bh);
            g3.drawImage((Image)img3, 0, 0, null);
            g3.setColor(Color.WHITE);
            g3.drawRect(0, 0, cw - 1, ch - 1);
            g3.dispose();
        }
    }

    private class ComponentListenerImpl
    implements ComponentListener {
        ImageCanvas root;

        private ComponentListenerImpl() {
            this.root = ImageCanvas.this;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }
    }

    private class MouseSupport
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        ImageCanvas root;
        private Point origPoint;
        private Point basePoint;
        private double[] BASE_FACTORS;
        private int baseFactorIndex;
        private double scaleFactor;

        private MouseSupport() {
            this.root = ImageCanvas.this;
            this.BASE_FACTORS = new double[]{6.0, 12.0, 25.0, 50.0, 66.0, 75.0, 100.0, 106.0, 112.0, 125.0, 150.0, 166.0, 175.0, 200.0, 250.0, 275.0, 300.0};
            this.baseFactorIndex = 6;
            this.scaleFactor = 1.0;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.hasIntersect(e)) {
                this.basePoint = e.getPoint();
                this.origPoint = new Point(((ImageCanvas)ImageCanvas.this).rectOver.x, ((ImageCanvas)ImageCanvas.this).rectOver.y);
            } else {
                this.basePoint = null;
                this.origPoint = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.basePoint = null;
            this.origPoint = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.basePoint == null) {
                return;
            }
            int pw = this.root.getWidth();
            int ph = this.root.getHeight();
            int nx = 0;
            int ny = 0;
            Point p = e.getPoint();
            if (p.x >= this.basePoint.x) {
                nx = p.x - this.basePoint.x;
                if (this.origPoint.x + nx + ((ImageCanvas)ImageCanvas.this).rectOver.width < pw) {
                    ((ImageCanvas)ImageCanvas.this).rectOver.x = this.origPoint.x + nx;
                }
            } else {
                nx = this.basePoint.x - p.x;
                ((ImageCanvas)ImageCanvas.this).rectOver.x = Math.max(this.origPoint.x - nx, 0);
            }
            if (p.y >= this.basePoint.y) {
                ny = p.y - this.basePoint.y;
                if (this.origPoint.y + ny + ((ImageCanvas)ImageCanvas.this).rectOver.height < ph) {
                    ((ImageCanvas)ImageCanvas.this).rectOver.y = this.origPoint.y + ny;
                }
            } else {
                ny = this.basePoint.y - p.y;
                ((ImageCanvas)ImageCanvas.this).rectOver.y = Math.max(this.origPoint.y - ny, 0);
            }
            this.root.repaint();
        }

        private boolean hasIntersect(MouseEvent e) {
            if (this.root.rectOver == null) {
                return false;
            }
            Point p = e.getPoint();
            return ImageCanvas.this.rectOver.contains(p);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isControlDown()) {
                return;
            }
            if (this.root.iicon == null) {
                return;
            }
            int oldBaseFactorIndex = this.baseFactorIndex;
            double oldScaleFactor = this.scaleFactor;
            try {
                if (e.getWheelRotation() > 0) {
                    this.scaleFactor = this.BASE_FACTORS[this.baseFactorIndex - 1] / 100.0;
                    --this.baseFactorIndex;
                } else {
                    this.scaleFactor = this.BASE_FACTORS[this.baseFactorIndex + 1] / 100.0;
                    ++this.baseFactorIndex;
                }
            }
            catch (Throwable t) {
                return;
            }
            BufferedImage oldImage = this.root.getBufferedImage();
            try {
                this.root.createBufferedImage(this.scaleFactor);
                if (oldImage != null) {
                    oldImage.flush();
                }
            }
            catch (Throwable t) {
                this.baseFactorIndex = oldBaseFactorIndex;
                this.scaleFactor = oldScaleFactor;
            }
            this.root.repaint();
        }
    }
}

