/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.image;

import com.rameses.rcp.image.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class ContentPane
extends JPanel {
    private JPanel toolbar;
    private ImageCanvas canvas;

    public ContentPane() {
        this.setLayout(new BorderLayout());
        this.initComponent();
    }

    private void initComponent() {
        this.toolbar = new JPanel(new ToolbarLayout());
        this.toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.toolbar, "South");
        JButton btnOK = new JButton("   OK   ");
        btnOK.setFont(btnOK.getFont().deriveFont(12.0f));
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.toolbar.add(btnOK);
        JButton btnCancel = new JButton(" Cancel ");
        btnCancel.setFont(btnCancel.getFont().deriveFont(12.0f));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.toolbar.add(btnCancel);
        this.canvas = new ImageCanvas();
        this.add(this.canvas);
    }

    public void setData(Object data) {
        this.canvas.setData(data);
    }

    private class ToolbarLayout
    implements LayoutManager {
        ContentPane root;

        private ToolbarLayout() {
            this.root = ContentPane.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + 3;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
            }
        }
    }
}

