/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.rameses.rcp.fingerprint.ImageContext;
import java.io.File;

public class FingerPrintResultInfo {
    private ImageContext[] results;

    FingerPrintResultInfo(ImageContext[] results) {
        this.results = results;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.length == 0;
    }

    public int size() {
        return this.results == null ? 0 : this.results.length;
    }

    public byte[] getLeftThumbData() {
        return this.getData(32);
    }

    public byte[] getLeftIndexData() {
        return this.getData(64);
    }

    public byte[] getLeftMiddleData() {
        return this.getData(128);
    }

    public byte[] getLeftRingData() {
        return this.getData(256);
    }

    public byte[] getLeftLittleData() {
        return this.getData(512);
    }

    public byte[] getRightThumbData() {
        return this.getData(1);
    }

    public byte[] getRightIndexData() {
        return this.getData(2);
    }

    public byte[] getRightMiddleData() {
        return this.getData(4);
    }

    public byte[] getRightRingData() {
        return this.getData(8);
    }

    public byte[] getRightLittleData() {
        return this.getData(16);
    }

    public byte[] getLeftThumbFmdData() {
        return this.getFmdData(32);
    }

    public byte[] getLeftIndexFmdData() {
        return this.getFmdData(64);
    }

    public byte[] getLeftMiddleFmdData() {
        return this.getFmdData(128);
    }

    public byte[] getLeftRingFmdData() {
        return this.getFmdData(256);
    }

    public byte[] getLeftLittleFmdData() {
        return this.getFmdData(512);
    }

    public byte[] getRightThumbFmdData() {
        return this.getFmdData(1);
    }

    public byte[] getRightIndexFmdData() {
        return this.getFmdData(2);
    }

    public byte[] getRightMiddleFmdData() {
        return this.getFmdData(4);
    }

    public byte[] getRightRingFmdData() {
        return this.getFmdData(8);
    }

    public byte[] getRightLittleFmdData() {
        return this.getFmdData(16);
    }

    public byte[] getData(int fingerType) {
        ImageContext ctx = this.getImageContext(fingerType);
        return ctx == null ? null : ctx.toByteArray();
    }

    public byte[] getFmdData(int fingerType) {
        ImageContext ctx = this.getImageContext(fingerType);
        return ctx == null ? null : ctx.getFmdData();
    }

    private ImageContext getImageContext(int fingerType) {
        if (this.results == null || this.results.length == 0) {
            return null;
        }
        for (ImageContext ctx : this.results) {
            if ((ctx.getFingerType() & fingerType) != fingerType) continue;
            return ctx;
        }
        return null;
    }

    public void exportToFile(int fingerType, String filename) {
        this.exportToFile(fingerType, filename, "JPG");
    }

    public void exportToFile(int fingerType, String filename, String fileFormat) {
        for (ImageContext ctx : this.results) {
            if ((ctx.getFingerType() & fingerType) != fingerType) continue;
            ctx.exportToFile(new File(filename), fileFormat);
            break;
        }
    }
}

