/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Reader;
import com.digitalpersona.uareu.UareUException;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.fingerprint.CaptureThread;
import com.rameses.rcp.fingerprint.FingerPrintDataModel;
import com.rameses.rcp.fingerprint.FingerPrintImage;
import com.rameses.rcp.fingerprint.ImageContext;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.JPanel;

class FingerPrintPanel
extends JPanel {
    private FingerPrintDataModel model = new FingerPrintDataModel();
    private Reader reader;
    private boolean streaming;
    private CaptureThread capture_thread;
    private ImageContext imageContext;

    public FingerPrintPanel() {
        this.addContainerListener(new ContainerListenerImpl());
        this.setFingerType(33);
    }

    void start(Reader reader, boolean streaming) {
        if (this.capture_thread != null) {
            return;
        }
        this.reader = reader;
        this.streaming = streaming;
        this.startCaptureThread();
    }

    void stop() {
        if (this.capture_thread != null) {
            this.capture_thread.cancel();
        }
    }

    void waitForCaptureThread() {
        if (this.capture_thread != null) {
            this.capture_thread.join(1000);
        }
    }

    ImageContext[] getImageContexts() {
        ArrayList<ImageContext> list = new ArrayList<ImageContext>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            FingerPrintImage fpi;
            ImageContext ctx;
            if (!(comps[i] instanceof FingerPrintImage) || (ctx = (fpi = (FingerPrintImage)comps[i]).getImageContext()) == null) continue;
            list.add(ctx);
        }
        return list.toArray(new ImageContext[list.size()]);
    }

    private void startCaptureThread() {
        this.capture_thread = new CaptureThread(this.reader, this.streaming, Fid.Format.ANSI_381_2004, Reader.ImageProcessing.IMG_PROC_DEFAULT);
        this.capture_thread.start(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FingerPrintPanel.this.actionPerformedImpl(e);
            }
        });
    }

    private void actionPerformedImpl(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!"finger_print_capture_thread".equals(cmd)) {
            return;
        }
        ImageContext newImageContext = null;
        boolean cancelled = false;
        CaptureThread.CaptureEvent evt = (CaptureThread.CaptureEvent)e;
        if (evt.getException() != null) {
            UareUException ue = evt.getException();
            String str = String.format("%s returned error %d \n%s", "Capture", ue.getCode() & 0xFFFF, ue.toString());
            MsgBox.err((Object)str);
        } else if (evt.getResult() != null) {
            Reader.CaptureResult result = evt.getResult();
            if (result.image != null && result.quality == Reader.CaptureQuality.GOOD) {
                newImageContext = new ImageContext(result.image);
            } else if (result.quality == Reader.CaptureQuality.CANCELED) {
                cancelled = true;
            } else {
                MsgBox.err((Object)result.quality);
            }
        } else if (evt.getStatus() != null) {
            String str = String.format("Reader status: %s", evt.getStatus().toString());
            MsgBox.err((Object)str);
        }
        this.imageContext = newImageContext;
        this.fireImageDataChanged(this.imageContext);
        FingerPrintDataModel.Item dmi = this.model.getSelectedItem();
        if (dmi != null) {
            dmi.setImageContext(this.imageContext);
        }
        if (!cancelled && !this.streaming) {
            this.waitForCaptureThread();
            this.startCaptureThread();
        }
    }

    private void fireImageDataChanged(final ImageContext ctx) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                byte[] data = ctx == null ? null : ctx.getImageData();
                FingerPrintPanel.this.firePropertyChange("imageDataChanged", "", data);
            }
        });
    }

    public void setFingerType(int type) {
        this.removeAll();
        if ((type & 0x20) == 32) {
            this.add(new FingerPrintImage("Left Thumb", 32));
        }
        if ((type & 1) == 1) {
            this.add(new FingerPrintImage("Right Thumb", 1));
        }
        if (this.model.getSelectedItem() == null) {
            this.model.setSelectedItem(this.model.getItem(0));
        }
        this.model.refresh();
    }

    private class ContainerListenerImpl
    implements ContainerListener {
        FingerPrintPanel root;

        private ContainerListenerImpl() {
            this.root = FingerPrintPanel.this;
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (!(c instanceof FingerPrintDataModel.Item)) {
                return;
            }
            FingerPrintDataModel.Item item = (FingerPrintDataModel.Item)((Object)c);
            this.root.model.add(item);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (!(c instanceof FingerPrintDataModel.Item)) {
                return;
            }
            FingerPrintDataModel.Item item = (FingerPrintDataModel.Item)((Object)c);
            this.root.model.remove(item);
        }
    }
}

