/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Reader;
import com.digitalpersona.uareu.UareUException;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class CaptureThread
extends Thread {
    public static final String ACT_CAPTURE = "finger_print_capture_thread";
    private ActionListener actionListener;
    private boolean cancelled = false;
    private CaptureEvent last_capture_event;
    private Reader reader;
    private boolean streaming;
    private Fid.Format img_format;
    private Reader.ImageProcessing img_proc;

    public CaptureThread(Reader reader, boolean streaming) {
        this(reader, streaming, Fid.Format.ANSI_381_2004, Reader.ImageProcessing.IMG_PROC_DEFAULT);
    }

    public CaptureThread(Reader reader, boolean streaming, Fid.Format img_format, Reader.ImageProcessing img_proc) {
        this.reader = reader;
        this.streaming = streaming;
        this.img_format = img_format;
        this.img_proc = img_proc;
    }

    public void start(ActionListener actionListener) {
        this.actionListener = actionListener;
        super.start();
    }

    public void join(int milliseconds) {
        try {
            super.join(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public CaptureEvent getLastCaptureEvent() {
        return this.last_capture_event;
    }

    private void capture() {
        try {
            Reader.CaptureResult result;
            boolean reader_ready = false;
            while (!reader_ready && !this.cancelled) {
                Reader.Status rstat = this.reader.GetStatus();
                if (Reader.ReaderStatus.BUSY == rstat.status) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (Reader.ReaderStatus.READY == rstat.status || Reader.ReaderStatus.NEED_CALIBRATION == rstat.status) {
                    reader_ready = true;
                    break;
                }
                this.notifyListener(ACT_CAPTURE, null, rstat, null);
                break;
            }
            if (this.cancelled) {
                result = new Reader.CaptureResult();
                result.quality = Reader.CaptureQuality.CANCELED;
                this.notifyListener(ACT_CAPTURE, result, null, null);
            }
            if (reader_ready) {
                result = this.reader.Capture(this.img_format, this.img_proc, 500, -1);
                this.notifyListener(ACT_CAPTURE, result, null, null);
            }
        }
        catch (UareUException e) {
            this.notifyListener(ACT_CAPTURE, null, null, e);
        }
    }

    private void stream() {
        try {
            boolean reader_ready = false;
            while (!reader_ready && !this.cancelled) {
                Reader.Status rstat = this.reader.GetStatus();
                if (Reader.ReaderStatus.BUSY == rstat.status) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (Reader.ReaderStatus.READY == rstat.status || Reader.ReaderStatus.NEED_CALIBRATION == rstat.status) {
                    reader_ready = true;
                    break;
                }
                this.notifyListener(ACT_CAPTURE, null, rstat, null);
                break;
            }
            if (reader_ready) {
                this.reader.StartStreaming();
                while (!this.cancelled) {
                    Reader.CaptureResult result = this.reader.GetStreamImage(this.img_format, this.img_proc, 500);
                    this.notifyListener(ACT_CAPTURE, result, null, null);
                }
                this.reader.StopStreaming();
            }
        }
        catch (UareUException e) {
            this.notifyListener(ACT_CAPTURE, null, null, e);
        }
        if (this.cancelled) {
            Reader.CaptureResult result = new Reader.CaptureResult();
            result.quality = Reader.CaptureQuality.CANCELED;
            this.notifyListener(ACT_CAPTURE, result, null, null);
        }
    }

    public void cancel() {
        this.cancelled = true;
        try {
            if (!this.streaming) {
                this.reader.CancelCapture();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (this.streaming) {
            this.stream();
        } else {
            this.capture();
        }
    }

    private void notifyListener(String action, Reader.CaptureResult result, Reader.Status status, UareUException exception) {
        CaptureEvent evt;
        this.last_capture_event = evt = new CaptureEvent(this, action, result, status, exception);
        if (this.actionListener == null || action == null || action.equals("")) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaptureThread.this.actionListener.actionPerformed(evt);
            }
        });
    }

    public class CaptureEvent
    extends ActionEvent {
        private static final long serialVersionUID = 1L;
        public Reader.CaptureResult result;
        public Reader.Status status;
        public UareUException exception;

        CaptureEvent(Object source, String action, Reader.CaptureResult result, Reader.Status status, UareUException exception) {
            super(source, 1001, action);
            this.result = result;
            this.status = status;
            this.exception = exception;
        }

        public Reader.CaptureResult getResult() {
            return this.result;
        }

        public Reader.Status getStatus() {
            return this.status;
        }

        public UareUException getException() {
            return this.exception;
        }
    }
}

