/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.camera.WebcamViewer;
import com.rameses.rcp.common.CallbackHandler;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.CameraModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UICommand;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class XCamera
extends JButton
implements MouseEventSupport.ComponentInfo,
UICommand,
ActionListener,
ActiveControl {
    private MouseEventSupport mouseSupport = new MouseEventSupport((JComponent)this);
    private String accelerator;
    private KeyStroke acceleratorKS;
    private String expression;
    private String handler;
    private String iconResource;
    private String target;
    private String permission;
    private boolean immediate;
    private boolean update;
    private boolean defaultCommand;
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private FontSupport fontSupport;
    private Font sourceFont;
    private String fontStyle;
    private ControlProperty property;

    public XCamera() {
        this.mouseSupport.install();
        this.addActionListener(this);
        this.setIconResource("images/toolbars/camera.png");
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
        try {
            if (this.acceleratorKS != null) {
                this.unregisterKeyboardAction(this.acceleratorKS);
            }
            this.acceleratorKS = KeyStroke.getKeyStroke(accelerator);
            if (this.acceleratorKS != null) {
                this.registerKeyboardAction(this, this.acceleratorKS, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        this.setIcon(ImageIconSupport.getInstance().getIcon(iconResource));
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public void setFont(Font font) {
        Map attrs;
        this.sourceFont = font;
        if (this.sourceFont != null && !(attrs = this.getFontSupport().createFontAttributes(this.getFontStyle())).isEmpty()) {
            this.sourceFont = this.sourceFont.deriveFont(attrs);
        }
        super.setFont(this.sourceFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        Font font;
        this.fontStyle = fontStyle;
        if (this.sourceFont == null) {
            this.sourceFont = super.getFont();
        }
        if ((font = this.sourceFont) == null) {
            return;
        }
        Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
        if (!attrs.isEmpty()) {
            font = font.deriveFont(attrs);
        }
        super.setFont(font);
    }

    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accelerator", this.getAccelerator());
        map.put("mnemonic", Character.valueOf((char)this.getMnemonic()));
        map.put("defaultCommand", this.isDefaultCommand());
        map.put("handler", this.getHandler());
        map.put("immediate", this.isImmediate());
        map.put("target", this.getTarget());
        return map;
    }

    public String getActionName() {
        return null;
    }

    public boolean isAutoRefresh() {
        return false;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isDefaultCommand() {
        return this.defaultCommand;
    }

    public void setDefaultCommand(boolean defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void load() {
    }

    public void refresh() {
        String whenExpr;
        Object bean;
        String expression = this.getExpression();
        Object object = bean = this.getBinding() == null ? null : this.getBinding().getBean();
        if (expression != null && expression.length() > 0 && bean != null) {
            Object result = UIControlUtil.evaluateExpr((Object)bean, (String)expression);
            this.setText(result == null ? "" : result.toString());
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean((Object)bean, (String)whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare((UIControl)this, (Object)o);
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        boolean shiftDown;
        boolean ctrlDown = (e.getModifiers() & 2) == 2;
        boolean bl = shiftDown = (e.getModifiers() & 1) == 1;
        if (ctrlDown && shiftDown) {
            this.mouseSupport.showComponentInfo();
            return;
        }
        this.processAction();
    }

    protected void processAction() {
        String handler = this.getHandler();
        Object bean = this.getBinding().getBean();
        Object ohandler = UIControlUtil.getBeanValue((Object)bean, (String)handler);
        CameraModel model = null;
        model = ohandler instanceof CameraModel ? (CameraModel)ohandler : new DefaultCameraModel(ohandler);
        model.setProvider(new DefaultCameraModelProvider());
        this.openViewer(model);
    }

    private void openViewer(CameraModel model) {
        WebcamViewer.open(model);
    }

    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private class BuiltinCloseHandler
    implements CallbackHandler {
        private CameraModel model;

        BuiltinCloseHandler(CameraModel model) {
            this.model = model;
        }

        public Object call(Object[] args) {
            return null;
        }

        public Object call(Object arg) {
            return null;
        }

        public Object call() {
            this.model.onclose();
            return null;
        }
    }

    private class BuiltinSelectHandler
    implements CallbackHandler {
        private CameraModel model;

        BuiltinSelectHandler(CameraModel model) {
            this.model = model;
        }

        public Object call(Object[] args) {
            return null;
        }

        public Object call() {
            return null;
        }

        public Object call(Object arg) {
            this.model.onselect((byte[])arg);
            return null;
        }
    }

    private class DefaultCameraModelProvider
    implements CameraModel.Provider {
        XCamera root;

        private DefaultCameraModelProvider() {
            this.root = XCamera.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void showDialog(CameraModel model) {
            this.root.openViewer(model);
        }
    }

    private class DefaultCameraModel
    extends CameraModel {
        private Object callback;
        private CallbackHandlerProxy proxy;

        DefaultCameraModel(Object callback) {
            if (callback != null) {
                this.proxy = new CallbackHandlerProxy(callback);
            }
        }

        @Override
        public void onselect(byte[] bytes) {
            if (this.proxy == null) {
                return;
            }
            this.proxy.call((Object)bytes);
        }
    }
}

