/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import java.io.File;

public class ImageModel {
    private String title;
    private int width;
    private int height;
    private Object data;
    private String filterDescription;
    private Provider provider;

    public ImageModel() {
        this.setTitle("Image Viewer");
        this.setWidth(800);
        this.setHeight(600);
        this.setFilterDescription("*.jpg|*.png|*.gif");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public void setFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
    }

    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        return this.accept(file.getName(), file.isDirectory());
    }

    public boolean accept(String filename, boolean directory) {
        if (directory) {
            return true;
        }
        String s = filename.toLowerCase();
        return s.endsWith(".jpg") || s.endsWith(".png") || s.endsWith(".gif");
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Object getBinding() {
        return this.provider == null ? null : this.provider.getBinding();
    }

    public void showDialog() {
        if (this.provider != null) {
            this.provider.showDialog(this);
        }
    }

    public static interface Provider {
        public Object getBinding();

        public void showDialog(ImageModel var1);
    }
}

