/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.camera;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDiscoveryEvent;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamPanel;
import com.rameses.rcp.camera.WebcamPaneListener;
import com.rameses.rcp.camera.WebcamViewer;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.support.ImageIconSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class WebcamPane
extends JPanel {
    private WebcamViewer viewer;
    private Webcam webcam;
    private WebcamPanel wcp;
    private JToolBar toolbar;
    private JButton btnShoot;
    private JComboBox cboDevices;
    private JComboBox cboSizes;
    private DefaultComboBoxModel deviceModel;
    private List<Webcam> webcams;
    private List<WebcamPaneListener> listeners = new ArrayList<WebcamPaneListener>();
    private boolean autoCloseOnSelect;

    public WebcamPane(WebcamViewer viewer) {
        this.viewer = viewer;
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(370, 290));
        this.webcams = Webcam.getWebcams();
        Webcam.addDiscoveryListener((WebcamDiscoveryListener)new WebcamDiscoveryListener(){

            public void webcamFound(WebcamDiscoveryEvent e) {
                System.out.println("webcamFound: " + e.getWebcam());
                this.reloadDevices();
            }

            public void webcamGone(WebcamDiscoveryEvent e) {
                System.out.println("webcamGone: " + e.getWebcam());
                this.reloadDevices();
            }

            private void reloadDevices() {
                WebcamPane.this.deviceModel = new WCDeviceModel();
                WebcamPane.this.cboDevices.setModel(WebcamPane.this.deviceModel);
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(false);
        this.toolbar.setLayout(new ToolbarLayout());
        this.toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.toolbar, "South");
        this.deviceModel = new DefaultComboBoxModel();
        this.cboDevices = new JComboBox();
        this.cboDevices.setEnabled(false);
        this.cboDevices.addItemListener(new WCDeviceSelector());
        this.toolbar.add((Component)this.cboDevices, "left");
        this.cboSizes = new JComboBox();
        this.cboSizes.setEnabled(false);
        this.cboSizes.addItemListener(new WCResolutionSelector());
        this.toolbar.add((Component)this.cboSizes, "left");
        this.btnShoot = new JButton("Shoot");
        this.btnShoot.setEnabled(false);
        this.btnShoot.setFocusPainted(false);
        this.btnShoot.setIcon(ImageIconSupport.getInstance().getIcon("images/toolbars/camera.png"));
        this.btnShoot.addActionListener(new ShootActionSupport(this.btnShoot));
        this.toolbar.add((Component)this.btnShoot, "right");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setFocusPainted(false);
        btnCancel.setIcon(ImageIconSupport.getInstance().getIcon("images/toolbars/cancel.png"));
        btnCancel.addActionListener(new CancelActionSupport());
        this.toolbar.add((Component)btnCancel, "right");
    }

    private void initWebcam() {
        this.initWebcam(WebcamViewer.CACHE.getProperty("webcam.name"));
    }

    private void initWebcam(String name) {
        Webcam new_webcam;
        if (this.webcams == null) {
            this.webcams = Webcam.getWebcams();
        }
        if ((new_webcam = this.findWebcam(name)) == null) {
            return;
        }
        System.out.println("initWebcam ...(" + name + ")");
        if (this.wcp != null) {
            this.wcp.stop();
        }
        if (this.wcp != null) {
            this.remove((Component)this.wcp);
            this.wcp = null;
            this.revalidate();
            this.repaint();
        }
        this.webcam = new_webcam;
        this.cboSizes.removeAllItems();
        this.webcam.addWebcamListener((WebcamListener)new WebcamPanelSupport());
        for (WebcamPaneListener wpl : this.listeners) {
            wpl.oncreate(this.webcam);
        }
        WebcamViewer.CACHE.setProperty("webcam.name", this.webcam.getDevice().getName());
        this.deviceModel = new WCDeviceModel();
        this.cboDevices.setModel(this.deviceModel);
        this.cboDevices.setEnabled(true);
        this.cboSizes.setModel(new WCResolutionModel());
        this.wcp = new WebcamPanel(this.webcam, this.webcam.getViewSize(), false);
        this.wcp.setFPSDisplayed(true);
        this.wcp.setFillArea(true);
        this.add((Component)this.wcp);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!WebcamPane.this.wcp.isStarted()) {
                    WebcamPane.this.wcp.start();
                }
                WebcamPane.this.revalidate();
                WebcamPane.this.repaint();
            }
        });
    }

    private Webcam findWebcam(String name) {
        List webcams = Webcam.getWebcams();
        if (webcams.isEmpty()) {
            throw new RuntimeException("No available Webcam on your computer");
        }
        for (Webcam wc : webcams) {
            if (name == null || name.length() == 0) {
                return wc;
            }
            if (!name.equalsIgnoreCase(wc.getDevice().getName())) continue;
            return wc;
        }
        return (Webcam)webcams.get(0);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    void setAutoCloseOnSelect(boolean autoCloseOnSelect) {
        this.autoCloseOnSelect = autoCloseOnSelect;
    }

    public void removeListener(WebcamPaneListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void addListener(WebcamPaneListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void start() {
        if (this.wcp == null) {
            this.initWebcam();
        }
        this.wcp.start();
    }

    public void stop() {
        if (this.wcp != null) {
            this.wcp.stop();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.WHITE);
        String str = "loading device ...";
        if (this.webcams.isEmpty()) {
            str = "No available Webcam device";
        }
        g2.drawString(str, 20, 30);
        g2.dispose();
    }

    private class CancelActionSupport
    implements ActionListener {
        WebcamPane root;

        private CancelActionSupport() {
            this.root = WebcamPane.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.root.stop();
            }
            catch (Throwable t) {
                MsgBox.err((Throwable)t);
            }
            try {
                this.cancel();
            }
            catch (Throwable t) {
                MsgBox.err((Throwable)t);
            }
        }

        private void cancel() {
            for (WebcamPaneListener listener : this.root.listeners) {
                listener.oncancel();
            }
        }
    }

    private class ShootActionSupport
    implements ActionListener {
        WebcamPane root;
        private JButton button;

        ShootActionSupport(JButton button) {
            this.root = WebcamPane.this;
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.setEnabled(false);
            this.button.setText("Processing...");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShootActionSupport.this.runImpl();
                }
            });
        }

        private void runImpl() {
            try {
                this.shoot();
            }
            catch (Throwable t) {
                MsgBox.err((Throwable)t);
            }
            finally {
                this.button.setText("Shoot");
                this.button.setEnabled(true);
            }
        }

        private void shoot() {
            BufferedImage bi = null;
            try {
                bi = this.root.webcam.getImage();
            }
            catch (Throwable t) {
                MsgBox.err((Throwable)t);
            }
            if (bi == null) {
                return;
            }
            byte[] bytes = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, "JPG", baos);
                bytes = baos.toByteArray();
            }
            catch (Throwable t) {
                MsgBox.err((Throwable)t);
                return;
            }
            if (bytes == null) {
                return;
            }
            try {
                if (WebcamPane.this.autoCloseOnSelect) {
                    this.root.stop();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (WebcamPaneListener listener : this.root.listeners) {
                listener.onselect(bytes);
            }
        }
    }

    private class WebcamPanelSupport
    implements WebcamListener {
        WebcamPane root;

        private WebcamPanelSupport() {
            this.root = WebcamPane.this;
        }

        public void webcamOpen(WebcamEvent we) {
            WebcamPane.this.cboDevices.setEnabled(true);
            WebcamPane.this.cboSizes.setEnabled(true);
            WebcamPane.this.btnShoot.setEnabled(true);
            WebcamPane.this.btnShoot.repaint();
            WebcamPane.this.btnShoot.requestFocus();
        }

        public void webcamClosed(WebcamEvent we) {
            WebcamPane.this.cboSizes.setEnabled(false);
            WebcamPane.this.btnShoot.setEnabled(false);
            WebcamPane.this.btnShoot.repaint();
            if (WebcamPane.this.btnShoot.hasFocus()) {
                WebcamPane.this.btnShoot.transferFocus();
            }
            this.removeWebcamPanel();
        }

        public void webcamDisposed(WebcamEvent we) {
            WebcamPane.this.cboSizes.setEnabled(false);
            WebcamPane.this.btnShoot.setEnabled(false);
            WebcamPane.this.btnShoot.repaint();
            if (WebcamPane.this.btnShoot.hasFocus()) {
                WebcamPane.this.btnShoot.transferFocus();
            }
        }

        public void webcamImageObtained(WebcamEvent we) {
        }

        private void removeWebcamPanel() {
            WebcamPanel wcp = this.root.wcp;
            if (wcp == null) {
                return;
            }
            if (wcp != null) {
                this.root.remove((Component)wcp);
                this.root.wcp = null;
                this.root.revalidate();
                this.root.repaint();
            }
        }
    }

    private class FooterLayout
    implements LayoutManager {
        WebcamPane root;

        private FooterLayout() {
            this.root = WebcamPane.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + 3;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component c;
                int i;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                int size = 0;
                Component[] comps = parent.getComponents();
                for (i = 0; i < comps.length; ++i) {
                    c = comps[i];
                    if (!c.isVisible()) continue;
                    dim = c.getPreferredSize();
                    size += dim.width + 3;
                }
                x = Math.max((w - size) / 2, 0) + margin.left;
                for (i = 0; i < comps.length; ++i) {
                    c = comps[i];
                    if (!c.isVisible()) continue;
                    dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
            }
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        WebcamPane root;
        private Vector<Component> leftComponents;
        private Vector<Component> rightComponents;

        private ToolbarLayout() {
            this.root = WebcamPane.this;
            this.leftComponents = new Vector();
            this.rightComponents = new Vector();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (comp == null) {
                return;
            }
            if ("right".equalsIgnoreCase(name + "")) {
                this.rightComponents.removeElement(comp);
                this.rightComponents.addElement(comp);
            } else {
                this.leftComponents.removeElement(comp);
                this.leftComponents.addElement(comp);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == null) {
                return;
            }
            this.leftComponents.removeElement(comp);
            this.rightComponents.removeElement(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + 3;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                boolean size = false;
                for (int i = 0; i < this.leftComponents.size(); ++i) {
                    Component c = this.leftComponents.get(i);
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
                int remWidth = pw - margin.right;
                int rightWidth = this.getRightWidth();
                int rightX = remWidth - (x + rightWidth);
                if (rightX < 0) {
                    rightX = 0;
                }
                x += rightX;
                for (int i = 0; i < this.rightComponents.size(); ++i) {
                    Component c = this.rightComponents.get(i);
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
            }
        }

        private int getRightWidth() {
            int width = 0;
            for (int i = 0; i < this.rightComponents.size(); ++i) {
                Component c = this.rightComponents.get(i);
                if (!c.isVisible()) continue;
                Dimension dim = c.getPreferredSize();
                width += dim.width + 3;
            }
            return width;
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        WebcamPane root;

        private DefaultLayout() {
            this.root = WebcamPane.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 320;
                int h = 240;
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                WebcamPanel c = this.root.wcp;
                if (c != null) {
                    Dimension dim;
                    JToolBar toolbar = this.root.toolbar;
                    if (toolbar != null) {
                        dim = ((Component)toolbar).getPreferredSize();
                        int ny1 = ph - margin.top;
                        int ny2 = ph - margin.bottom - dim.height;
                        int ny = Math.max(ny1, ny2);
                        toolbar.setBounds(x, ny, w, dim.height);
                        h -= dim.height;
                    }
                    dim = c.getPreferredSize();
                    c.setBounds(x, y, w, Math.max(h, 0));
                }
            }
        }
    }

    private class WCResolutionSelector
    implements ItemListener {
        private WCResolutionSelector() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                WCResolution res = (WCResolution)e.getItem();
                Dimension size = res.getSize();
                if (size == null) {
                    return;
                }
                WebcamViewer.CACHE.setProperty("webcam.width", size.width + "");
                WebcamViewer.CACHE.setProperty("webcam.height", size.height + "");
                String wc_name = WebcamPane.this.webcam.getDevice().getName();
                WebcamPane.this.initWebcam(wc_name);
            }
        }
    }

    private class WCResolution {
        private Dimension size;
        private String caption;

        WCResolution(Dimension size) {
            this.size = size;
            if (size != null) {
                this.caption = size.width + " x " + size.height;
            }
        }

        WCResolution(Dimension size, String caption) {
            this.size = size;
            this.caption = caption;
        }

        public Dimension getSize() {
            return this.size;
        }

        public String toString() {
            return this.caption == null ? "null" : this.caption;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WCResolution)) {
                return false;
            }
            WCResolution res = (WCResolution)obj;
            Dimension dim1 = res.getSize();
            Dimension dim2 = this.getSize();
            if (dim1 == null || dim2 == null) {
                return false;
            }
            return dim1.width == dim2.width && dim1.height == dim2.height;
        }
    }

    private class WCResolutionModel
    extends DefaultComboBoxModel {
        WebcamPane root;

        WCResolutionModel() {
            Dimension[] sizes;
            this.root = WebcamPane.this;
            if (this.root.webcam == null) {
                return;
            }
            for (Dimension dim : sizes = this.root.webcam.getViewSizes()) {
                this.addElement(new WCResolution(dim));
            }
            for (Dimension dim : sizes = this.root.webcam.getCustomViewSizes()) {
                this.addElement(new WCResolution(dim));
            }
            if (this.getSize() == 0) {
                this.addElement(new WCResolution(null, "-- Resolutions --"));
            } else {
                Dimension dim = this.root.webcam.getViewSize();
                this.setSelectedItem(new WCResolution(dim));
                WCResolution sel = (WCResolution)this.getSelectedItem();
                if (sel == null) {
                    this.setSelectedItem(this.getElementAt(0));
                }
            }
        }
    }

    private class WCDeviceSelector
    implements ItemListener {
        private WCDeviceSelector() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object item = e.getItem();
                if (!(item instanceof WCDevice)) {
                    return;
                }
                Object key = ((WCDevice)item).getKey();
                if (key == null) {
                    return;
                }
                WebcamPane.this.initWebcam(key.toString());
            }
        }
    }

    private class WCDevice {
        private Object key;
        private Object value;
        private Webcam webcam;

        WCDevice(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.value == null ? "null" : this.value.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WCDevice)) {
                return false;
            }
            WCDevice wc = (WCDevice)obj;
            Object key1 = wc.getKey();
            Object key2 = this.getKey();
            if (key1 == null && key2 == null) {
                return true;
            }
            return key1 != null && key2 != null && key1.equals(key2);
        }
    }

    private class WCDeviceModel
    extends DefaultComboBoxModel {
        WCDeviceModel() {
            List webcams = Webcam.getWebcams();
            if (webcams.isEmpty()) {
                this.addElement(new WCDevice(null, "-- Devices --"));
            } else {
                for (Webcam wc : webcams) {
                    String name = wc.getDevice().getName();
                    this.addElement(new WCDevice(name, name));
                }
                String wc_name = WebcamViewer.CACHE.getProperty("webcam.name");
                this.setSelectedItem(new WCDevice(wc_name, wc_name));
                WCDevice sel = (WCDevice)this.getSelectedItem();
                if (sel == null) {
                    this.setSelectedItem(this.getElementAt(0));
                }
            }
        }
    }
}

