/*
 * Decompiled with CFR 0.152.
 */
package system.module;

import com.rameses.io.IOStream;
import com.rameses.rcp.framework.ClientContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleManager {
    private List<Map> modules;
    private Map<String, Properties> confs;

    public List getModules() {
        if (this.modules == null) {
            this.loadModules();
        }
        return this.modules;
    }

    private void loadConfs() {
        try {
            this.confs = new HashMap<String, Properties>();
            ClassLoader classLoader = ClientContext.getCurrentContext().getClassLoader();
            Enumeration<URL> en = classLoader.getResources("META-INF/module.conf");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                String path = url.toString();
                if (!path.endsWith("!/META-INF/module.conf")) continue;
                Properties props = new Properties();
                props.load(url.openStream());
                int idx = path.lastIndexOf("/modules");
                if (idx < 0) continue;
                path = path.substring(idx);
                path = path.substring(0, path.lastIndexOf(33));
                this.confs.put(path, props);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void loadModules() {
        byte[] bytes;
        boolean securedfile = true;
        File basedir = new File(System.getProperty("user.dir"));
        File xmlfile = new File(basedir, "osiris2/modules/updates.sxml");
        if (!xmlfile.exists()) {
            xmlfile = new File(basedir, "osiris2/modules/updates.xml");
            securedfile = false;
        }
        if ((bytes = this.getContent(xmlfile, securedfile)) == null || bytes.length == 0) {
            this.modules = new ArrayList<Map>();
        } else {
            Conf conf = new Conf();
            this.modules = conf.parse(bytes);
        }
        this.loadConfs();
        for (Map map : this.modules) {
            String filename = (String)map.get("file");
            if (filename == null || filename.length() == 0) continue;
            String version = (String)map.get("version");
            if (version == null || version.length() == 0) {
                version = "1.0";
            }
            version = version.replaceAll("\\.", "_");
            if (filename.endsWith(".jar")) {
                int idx = filename.lastIndexOf(".jar");
                filename = filename.substring(0, idx);
            }
            String actualfile = filename + "-" + version + ".jar";
            map.put("actualfile", actualfile);
            Properties props = this.confs.get("/modules/" + actualfile);
            if (props == null) {
                props = new Properties();
            }
            map.put("conf", props);
        }
    }

    private byte[] getContent(File file, boolean secured) {
        if (!file.exists()) {
            return null;
        }
        if (secured) {
            Object serializeObj = null;
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                serializeObj = ois.readObject();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    ois.close();
                }
                catch (Throwable throwable) {}
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (serializeObj == null) {
                return null;
            }
            try {
                Object[] o = (Object[])serializeObj;
                if (o.length != 2) {
                    throw new RuntimeException("Error secured parameter count");
                }
                SecretKey sk = (SecretKey)o[0];
                SealedObject so = (SealedObject)o[1];
                Cipher dec = Cipher.getInstance("DES");
                dec.init(2, sk);
                Object obj = so.getObject(dec);
                return obj == null ? null : obj.toString().getBytes();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return IOStream.toByteArray((File)file);
    }

    private class Conf
    extends DefaultHandler {
        static final String FIND_PATH = "app/modules/module";
        StringBuilder pathbuilder = new StringBuilder();
        List<Map> modules = new ArrayList<Map>();

        private Conf() {
        }

        List<Map> parse(byte[] bytes) {
            ByteArrayInputStream bis = null;
            try {
                bis = new ByteArrayInputStream(bytes);
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse((InputStream)bis, (DefaultHandler)this);
                List<Map> list = this.modules;
                return list;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
        }

        String getPath() {
            return this.pathbuilder.toString();
        }

        String pushNode(String node) {
            if (this.pathbuilder.length() > 0) {
                this.pathbuilder.append("/");
            }
            this.pathbuilder.append(node);
            return this.getPath();
        }

        String popNode() {
            int idx = this.pathbuilder.lastIndexOf("/");
            if (idx > 0) {
                this.pathbuilder = this.pathbuilder.delete(idx, this.pathbuilder.length());
            } else {
                this.pathbuilder.delete(0, this.pathbuilder.length());
            }
            return this.getPath();
        }

        @Override
        public void startDocument() throws SAXException {
            this.pathbuilder = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String path = this.pushNode(qName);
            if (FIND_PATH.equalsIgnoreCase(path)) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String key = attrs.getQName(i);
                    String val = attrs.getValue(i);
                    map.put(key, val);
                }
                String filename = (String)map.get("file");
                map.put("name", filename);
                this.modules.add(map);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.popNode();
        }
    }
}

