/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.ExpressionResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerFilter;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.WorkUnitUIController;
import com.rameses.osiris2.common.ActionBuilder;
import com.rameses.osiris2.common.ListModelHandler;
import com.rameses.osiris2.common.PageListModelHandler;
import com.rameses.osiris2.flow.AbstractNode;
import com.rameses.osiris2.flow.SubProcessNode;
import com.rameses.osiris2.flow.Transition;
import com.rameses.rcp.annotations.Caller;
import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.ControlSupport;
import java.util.ArrayList;
import java.util.List;

public class PageFlowController {
    @Controller
    protected WorkUnitUIController workunit;
    @com.rameses.rcp.annotations.Binding
    private Binding binding;
    @Caller
    private Object caller;
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    private ListModelHandler listModelHandler;
    private List<Action> navActions;

    public Object onComplete() {
        return null;
    }

    public Object start() {
        this.workunit.getWorkunit().start();
        if (this.workunit.getWorkunit().isPageFlowCompleted()) {
            return "_close";
        }
        return this.workunit.getWorkunit().getCurrentPage().getName();
    }

    public Object start(String name) {
        this.workunit.getWorkunit().start(name);
        if (this.workunit.getWorkunit().isPageFlowCompleted()) {
            return "_close";
        }
        return this.workunit.getWorkunit().getCurrentPage().getName();
    }

    public Object signal() {
        return this.signal(null);
    }

    public Object signal(String msg) {
        return this.signal(msg, null);
    }

    private final PageFlowController getRootCaller() {
        if (this.caller instanceof PageFlowController) {
            return (PageFlowController)this.caller;
        }
        return this;
    }

    private final void buildStackClosed(StringBuilder sb) {
        if (this.caller != null) {
            sb.insert(0, "_close:");
            ((PageFlowController)this.caller).buildStackClosed(sb);
        }
    }

    public Object signal(String msg, String tag) {
        if (msg == null) {
            this.workunit.getWorkunit().signal();
        } else {
            this.workunit.getWorkunit().signal(msg);
        }
        if (this.workunit.getWorkunit().isPageFlowCompleted()) {
            Object retVal = this.onComplete();
            if (retVal != null) {
                return retVal;
            }
            return "_close";
        }
        AbstractNode node = this.workunit.getWorkunit().getCurrentNode();
        if (node instanceof SubProcessNode) {
            SubProcessNode pm = (SubProcessNode)node;
            String openerName = pm.getHandler();
            if (openerName == null) {
                throw new IllegalStateException("Please specify a handler in subprocess node");
            }
            Object bean = this.workunit.getWorkunit().getController();
            Object o = ExpressionResolver.getInstance().eval(openerName, bean);
            if (o instanceof String) {
                try {
                    return InvokerUtil.lookupOpener((String)((String)o));
                }
                catch (Throwable t) {
                    System.out.println("[WARN] error lookup actions caused by " + t.getMessage());
                }
            }
            return o;
        }
        String pageName = node.getName();
        if (pageName == null) {
            throw new RuntimeException("Page name must not be null");
        }
        return pageName;
    }

    public List<Action> getFormActions() {
        return this.getActions();
    }

    public List<Action> getNavActions() {
        if (this.navActions == null) {
            this.navActions = new ArrayList<Action>();
            try {
                List<Action> lst = this.lookupActions("navActions");
                if (lst != null) {
                    this.navActions.addAll(lst);
                }
            }
            catch (Throwable lst) {
                // empty catch block
            }
            if (this.getListModelHandler() instanceof PageListModelHandler) {
                ActionBuilder ab = new ActionBuilder();
                ab.add("moveBackRecord", "Move to previous record", "images/toolbars/arrow_up.png", null, '\u0000', "#{navActionVisible==true}", true);
                ab.add("moveNextRecord", "Move to next record", "images/toolbars/arrow_down.png", null, '\u0000', "#{navActionVisible==true}", true);
                this.navActions.addAll(ab.getActions());
            }
        }
        return this.navActions;
    }

    protected final List<Action> lookupActions(String type) {
        List<Action> actions = new ArrayList();
        try {
            actions = InvokerUtil.lookupActions((String)type, (InvokerFilter)new InvokerFilter(){

                public boolean accept(Invoker o) {
                    return o.getWorkunitid().equals(PageFlowController.this.invoker.getWorkunitid());
                }
            });
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup actions caused by " + t.getMessage());
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action newAction = actions.get(i).clone();
            actions.set(i, newAction);
        }
        return actions;
    }

    public boolean isNavActionVisible() {
        return false;
    }

    public Object moveBackRecord() {
        ListModelHandler lm = this.getListModelHandler();
        if (lm instanceof PageListModelHandler) {
            ((PageListModelHandler)lm).moveBackRecord();
            Object data = lm.getSelectedEntity();
            if (data != null) {
                return this.openRecord(data);
            }
        }
        return null;
    }

    public Object moveNextRecord() {
        ListModelHandler lm = this.getListModelHandler();
        if (lm instanceof PageListModelHandler) {
            ((PageListModelHandler)lm).moveNextRecord();
            Object data = lm.getSelectedEntity();
            if (data != null) {
                return this.openRecord(data);
            }
        }
        return null;
    }

    protected Object openRecord(Object data) {
        return null;
    }

    public StyleRule[] getStyleRules() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        List transitions = this.workunit.getWorkunit().getTransitions();
        for (Transition t : transitions) {
            boolean permitted;
            String domain = t.getDomain();
            if (domain == null) {
                domain = this.workunit.getWorkunit().getModule().getDomain();
            }
            if (!(permitted = ControlSupport.isPermitted((String)domain, (String)t.getRole(), (String)t.getPermission()))) continue;
            String tname = t.getName();
            if (tname == null) {
                tname = t.getTo();
            }
            TransitionAction a = new TransitionAction(tname);
            String sval = (String)t.getProperties().get("title");
            if (sval == null) {
                sval = (String)t.getProperties().get("caption");
            }
            if (sval == null) {
                sval = tname;
            }
            a.setCaption(sval);
            a.setTooltip(sval);
            a.setConfirm(t.getConfirm());
            sval = (String)t.getProperties().get("tag");
            a.setTag(sval);
            sval = (String)t.getProperties().get("icon");
            if (sval != null) {
                a.setIcon(sval);
            }
            if ((sval = (String)t.getProperties().get("visibleWhen")) != null) {
                a.setVisibleWhen(sval);
            }
            boolean immediate = true;
            try {
                sval = (String)t.getProperties().get("immediate");
                if (sval != null) {
                    immediate = Boolean.parseBoolean(sval);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                a.setImmediate(immediate);
            }
            if ((sval = (String)t.getProperties().get("mnemonic")) != null && sval.trim().length() > 0) {
                a.setMnemonic(sval.trim().charAt(0));
            }
            a.setDomain(domain);
            a.setRole(t.getRole());
            a.setPermission(t.getPermission());
            a.setShowCaption(true);
            String sdepends = (String)t.getProperties().get("depends");
            if (sdepends != null) {
                a.getProperties().put("depends", sdepends);
            }
            actions.add(a);
        }
        return actions;
    }

    public String getTitle() {
        String expr = this.workunit.getWorkunit().getStateTitle();
        Object bean = this.workunit.getWorkunit().getController();
        return ExpressionResolver.getInstance().evalString(expr, bean);
    }

    public String getState() {
        return this.workunit.getWorkunit().getCurrentNode().getName();
    }

    public Object getCaller() {
        return this.caller;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public ListModelHandler getListModelHandler() {
        return this.listModelHandler;
    }

    public void setListModelHandler(ListModelHandler listModelHandler) {
        this.listModelHandler = listModelHandler;
    }

    public class TransitionAction
    extends Action {
        private String confirm;
        private String tag;

        public TransitionAction(String name) {
            super(name);
        }

        public String getConfirm() {
            return this.confirm;
        }

        public void setConfirm(String confirm) {
            this.confirm = confirm;
        }

        public Object execute() {
            if (this.confirm != null && !MsgBox.confirm((Object)this.confirm)) {
                return null;
            }
            if (this.tag != null) {
                return PageFlowController.this.signal(this.getName(), this.tag);
            }
            return PageFlowController.this.signal(this.getName());
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }
}

