/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.common.BasicListController;
import com.rameses.osiris2.common.ListModelHandler;
import com.rameses.osiris2.common.ListService;
import com.rameses.osiris2.common.PageListModelHandler;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListItemStatus;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ListController
extends BasicListController
implements PageListModelHandler {
    private ListService service;
    private List formActions;
    private List navActions;
    private List<Map> contextMenuActions;
    private Map query = new HashMap();
    private String tag;
    private String formName;
    private int defaultRowSize = 20;
    protected String wuserviceName;
    private String wudomain;
    private String wurole;
    private String wuformName;
    private String wuformTarget = "popup";
    private String wutag;
    private Integer wurows;
    private Boolean wuallowClose;
    private Boolean wuallowCreate;
    private Boolean wuallowOpen;
    private Boolean wuallowSearch;
    private String wuentityName;
    private Boolean wuallowColumnEditing;
    private StringBuffer recordCountInfo;
    private StringBuffer pageCountInfo;

    public abstract String getServiceName();

    public String getConnection() {
        return null;
    }

    public String getEntityName() {
        if (this.wuentityName == null || this.wuentityName.length() == 0) {
            throw new RuntimeException("Please provide an entityName");
        }
        return this.wuentityName;
    }

    public String getDomain() {
        return this.wudomain;
    }

    public String getRole() {
        return this.wurole;
    }

    public String getTag() {
        return this.wutag == null ? this.tag : this.wutag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String getFormTarget() {
        if (this.wuformTarget == null || this.wuformTarget.length() == 0) {
            return "popup";
        }
        return this.wuformTarget;
    }

    public String getFormName() {
        if (this.wuformName == null || this.wuformName.length() == 0) {
            return this.formName;
        }
        return this.wuformName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getRows() {
        return this.wurows == null ? this.defaultRowSize : this.wurows;
    }

    public Map getQuery() {
        return this.query;
    }

    @Override
    public Opener getQueryForm() {
        if (this.isAllowSearch()) {
            Opener o = new Opener();
            o.setOutcome("queryform");
            return o;
        }
        return null;
    }

    protected void beforeGetColumns(Map params) {
    }

    @Override
    public Column[] getColumns() {
        return null;
    }

    public List<Map> getColumnList() {
        HashMap<String, String> params = new HashMap<String, String>();
        String stag = this.getTag();
        if (stag != null) {
            params.put("_tag", stag);
        }
        this.beforeGetColumns(params);
        return this.getService().getColumns(params);
    }

    public List<Map> getContextMenu(Object item, String columnName) {
        if (this.contextMenuActions == null) {
            this.contextMenuActions = new ArrayList<Map>();
            List<Action> actions = this.lookupActions("contextMenu");
            while (!actions.isEmpty()) {
                Action a = actions.remove(0);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("value", a.getCaption());
                map.put("action", (String)a);
                this.contextMenuActions.add(map);
            }
        }
        return this.contextMenuActions;
    }

    public Object callContextMenu(Object item, Object menuItem) {
        Map map;
        Object o;
        if (menuItem instanceof Map && ((o = (map = (Map)menuItem).get("action")) instanceof Action || o instanceof Opener || o instanceof String)) {
            return o;
        }
        return null;
    }

    public boolean isShowNavActions() {
        return true;
    }

    public boolean isShowFormActions() {
        return true;
    }

    public Map getCreatePermission() {
        return null;
    }

    public Map getReadPermission() {
        return null;
    }

    public boolean isAllowClose() {
        if (this.wuallowClose == null) {
            return true;
        }
        return this.wuallowClose;
    }

    public boolean isAllowCreate() {
        if (this.wuallowCreate == null) {
            return true;
        }
        return this.wuallowCreate;
    }

    public boolean isAllowOpen() {
        if (this.wuallowOpen == null) {
            return true;
        }
        return this.wuallowOpen;
    }

    public boolean isAllowSearch() {
        if (this.wuallowSearch == null) {
            return true;
        }
        return this.wuallowSearch;
    }

    public boolean isAllowColumnEditing() {
        if (this.wuallowColumnEditing == null) {
            return false;
        }
        return this.wuallowColumnEditing;
    }

    public boolean isAllowAdvancedSearch() {
        return false;
    }

    public Object getAdvancedSearch() {
        return null;
    }

    protected boolean onOpen(Map params) {
        return true;
    }

    protected boolean onCreate(Map params) {
        return true;
    }

    public Opener create() throws Exception {
        Map params = this.createOpenerParams();
        if (!this.onCreate(params)) {
            return null;
        }
        Opener opener = null;
        try {
            opener = InvokerUtil.lookupOpener((String)(this.getEntityName() + ":create"), (Map)params);
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup opener caused by " + t.getMessage());
            MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
        }
        if (opener == null) {
            return null;
        }
        String target = opener.getTarget() + "";
        if (!target.matches("window|popup|process|_window|_popup|_process")) {
            opener.setTarget(this.getFormTarget());
        }
        return opener;
    }

    protected String getEntityName(Map data) {
        return null;
    }

    @Override
    public Object open() throws Exception {
        String filetype;
        Map data = (Map)this.getSelectedEntity();
        if (data == null) {
            return null;
        }
        Map params = this.createOpenerParams();
        String string = filetype = data.get("filetype") == null ? null : data.get("filetype").toString();
        if (filetype != null && filetype.length() > 0) {
            params.put("listModelHandler", new ListModelHandlerProxy());
        } else {
            filetype = this.getEntityName();
            String en = this.getEntityName(data);
            if (en != null && en.length() > 0) {
                filetype = en;
            }
        }
        params.put("entity", data);
        if (!this.onOpen(params)) {
            return null;
        }
        Opener opener = null;
        try {
            String invtype = filetype + ":open";
            opener = InvokerUtil.lookupOpener((String)invtype, (Map)params);
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup opener caused by " + t.getMessage());
            MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
        }
        if (opener == null) {
            return null;
        }
        String target = opener.getTarget() + "";
        if (!target.matches("window|popup|process|_window|_popup|_process")) {
            opener.setTarget(this.getFormTarget());
        }
        return opener;
    }

    public Object close() {
        return "_close";
    }

    public void reset() {
        this.query.clear();
        this.search();
    }

    @Override
    public void search() {
        this.load();
    }

    protected Map createOpenerParams() {
        HashMap<String, ListController> params = new HashMap<String, ListController>();
        params.put("listModelHandler", this);
        return params;
    }

    @Override
    public List getNavActions() {
        if (this.navActions == null) {
            if (!this.isShowNavActions()) {
                return null;
            }
            this.navActions = new ArrayList();
            this.navActions.add(this.createAction("moveFirstPage", "", "images/navbar/first.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("moveBackPage", "", "images/navbar/previous.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("moveNextPage", "", "images/navbar/next.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("moveLastPage", "", "images/navbar/last.png", null, '\u0000', null, true));
        }
        return this.navActions;
    }

    @Override
    public List getFormActions() {
        if (this.formActions == null) {
            Action a;
            if (!this.isShowFormActions()) {
                return null;
            }
            this.formActions = new ArrayList();
            if (this.isAllowClose()) {
                this.formActions.add(this.createAction("close", "Close", "images/toolbars/cancel.png", "ctrl C", 'c', null, true));
            }
            if (this.isAllowCreate()) {
                a = this.createAction("create", "New", "images/toolbars/create.png", "ctrl N", 'n', null, true);
                this.loadPermissionDefaults(a, "create");
                this.loadPermission(a, this.getCreatePermission());
                this.formActions.add(a);
            }
            if (this.isAllowOpen()) {
                a = this.createAction("open", "Open", "images/toolbars/open.png", "ctrl O", 'o', "#{selectedEntity != null}", true);
                a.getProperties().put("depends", "selectedEntity");
                this.loadPermissionDefaults(a, "open");
                this.loadPermission(a, this.getReadPermission());
                this.formActions.add(a);
            }
            this.formActions.add(this.createAction("reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
        }
        return this.formActions;
    }

    protected Action createAction(String name, String caption, String icon, String shortcut, char mnemonic, String visibleWhen, boolean immediate) {
        Action a = new Action(name, caption, icon, mnemonic);
        if (visibleWhen != null) {
            a.setVisibleWhen(visibleWhen);
        }
        if (shortcut != null) {
            a.getProperties().put("shortcut", shortcut);
        }
        a.setImmediate(immediate);
        a.setShowCaption(true);
        return a;
    }

    private void loadPermission(Action a, Map perm) {
        String permission;
        String role;
        if (perm == null || perm.isEmpty()) {
            return;
        }
        String domain = this.getString(perm, "domain");
        if (domain != null && domain.length() > 0) {
            a.setDomain(domain);
        }
        if ((role = this.getString(perm, "role")) != null && role.length() > 0) {
            a.setRole(role);
        }
        if ((permission = this.getString(perm, "permission")) != null && permission.length() > 0) {
            a.setPermission(permission);
        }
    }

    private void loadPermissionDefaults(Action a, String permission) {
        String domain = this.getDomain();
        if ((domain == null || domain.length() == 0) && this.invoker != null) {
            domain = this.invoker.getDomain();
        }
        a.setDomain(domain);
        String role = this.getRole();
        if (role == null || role.length() == 0) {
            return;
        }
        a.setRole(role);
        String entityName = this.getEntityName();
        if (entityName != null && entityName.length() != 0 && permission != null && permission.length() > 0) {
            a.setPermission(entityName + "." + permission);
        }
    }

    protected String getString(Map map, String name) {
        Object ov = map == null ? null : (Object)map.get(name);
        return ov == null ? null : ov.toString();
    }

    protected Integer getInteger(Map map, String name) {
        try {
            String sval = this.getString(map, name);
            if (sval == null || sval.length() == 0) {
                return null;
            }
            return new Integer(Integer.parseInt(sval));
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Boolean getBoolean(Map map, String name) {
        try {
            String sval = this.getString(map, name);
            if (sval == null || sval.length() == 0) {
                return null;
            }
            if ("true".equals(sval)) {
                return new Boolean(true);
            }
            if ("false".equals(sval)) {
                return new Boolean(false);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    protected void handleWorkunitProperties(Map props) {
        if (props == null) {
            return;
        }
        this.wuformName = this.getString(props, "formName");
        this.wurows = this.getInteger(props, "rows");
        this.wuallowClose = this.getBoolean(props, "allowClose");
        this.wuallowCreate = this.getBoolean(props, "allowCreate");
        this.wuallowOpen = this.getBoolean(props, "allowOpen");
        this.wuallowSearch = this.getBoolean(props, "allowSearch");
        this.wuserviceName = this.getString(props, "serviceName");
        this.wuentityName = this.getString(props, "entityName");
        this.wudomain = this.getString(props, "domain");
        this.wurole = this.getString(props, "role");
        this.wuformTarget = this.getString(props, "formTarget");
        if (this.wuformTarget == null || this.wuformTarget.length() == 0) {
            this.wuformTarget = "popup";
        }
        this.wutag = this.getString(props, "tag");
        this.wuallowColumnEditing = this.getBoolean(props, "allowColumnEditing");
    }

    @Deprecated
    protected void onbeforeFetchList(Map params) {
        this.beforeFetchList(params);
    }

    @Deprecated
    protected void onafterFetchList(List list) {
        this.afterFetchList(list);
    }

    protected void beforeFetchList(Map params) {
    }

    protected void afterFetchList(List list) {
    }

    @Override
    public List fetchList(Map m) {
        Map qrymap;
        String stag = this.getTag();
        if (stag != null) {
            m.put("_tag", stag);
        }
        if ((qrymap = this.getQuery()) != null) {
            m.putAll(qrymap);
        }
        List list = this.getService().getList(m);
        return list;
    }

    protected ListService getService() {
        String name = this.getServiceName();
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("No service name specified");
        }
        if (this.service == null) {
            String sconn = this.getConnection();
            this.service = sconn == null || sconn.trim().length() == 0 ? (ListService)InvokerProxy.getInstance().create(name, ListService.class) : (ListService)InvokerProxy.getInstance().create(name, ListService.class, sconn);
        }
        return this.service;
    }

    protected void dataChanged(Object stat) {
        this.recordCountInfo = new StringBuffer();
        this.pageCountInfo = new StringBuffer();
        if (stat instanceof ListItemStatus) {
            ListItemStatus lis = (ListItemStatus)stat;
            this.recordCountInfo.append(lis.getTotalRows());
            this.recordCountInfo.append(" Record(s)    ");
            this.pageCountInfo.append("Page  " + lis.getPageIndex() + "  of  ");
            if (lis.isHasNextPage()) {
                if (lis.getPageIndex() < lis.getPageCount()) {
                    this.pageCountInfo.append(lis.getPageCount());
                } else {
                    this.pageCountInfo.append("?");
                }
            } else {
                this.pageCountInfo.append(lis.getPageCount());
            }
        }
    }

    public Object getRecordCountInfo() {
        return this.recordCountInfo;
    }

    public Object getPageCountInfo() {
        return this.pageCountInfo;
    }

    @Override
    public void addItem(Object data) {
        if (data == null) {
            return;
        }
        int idx = -1;
        try {
            idx = this.getListItems().indexOf(this.getSelectedItem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        List dataList = this.getDataList();
        if (idx >= 0 && idx < dataList.size()) {
            dataList.add(idx, data);
        } else {
            dataList.add(data);
            idx = dataList.size() - 1;
        }
        this.refresh();
        this.setSelectedItem(idx);
    }

    @Override
    public void updateItem(Object data) {
        ListItem item = this.getSelectedItem();
        if (item == null) {
            return;
        }
        if (data != null) {
            List dataList = this.getDataList();
            if (item.getIndex() >= 0 && item.getIndex() < dataList.size()) {
                dataList.set(item.getIndex(), data);
                item.loadItem(data);
                this.refreshSelectedItem();
            }
        }
    }

    @Override
    public void removeItem(Object data) {
        if (this.getSelectedEntity() == null) {
            return;
        }
        int idx = this.getListItems().indexOf(this.getSelectedItem());
        if (idx >= 0) {
            this.getDataList().remove(idx);
            this.refresh();
        }
    }

    private class ListModelHandlerProxy
    implements ListModelHandler {
        ListController root;

        private ListModelHandlerProxy() {
            this.root = ListController.this;
        }

        @Override
        public Object getSelectedEntity() {
            return this.root.getSelectedEntity();
        }

        @Override
        public void addItem(Object data) {
            this.root.addItem(data);
        }

        @Override
        public void updateItem(Object data) {
            this.root.updateItem(data);
        }

        @Override
        public void removeItem(Object data) {
            this.root.removeItem(data);
        }
    }
}

