/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.WorkUnitUIController;
import com.rameses.osiris2.common.ExplorerViewService;
import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.ControlSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxDocController {
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    @Controller
    protected WorkUnitUIController controller;
    private String context;
    private String defaultFileType;
    private String serviceName;
    private TreeNodeModel nodeModel;
    private Node selectedNode;
    private ExplorerViewService service;
    private List<Action> formActions;
    private ActionsProvider actionsProvider = new ActionsProvider();
    private Helper helper = new Helper();
    private Opener opener;
    private Node _selectedOpenNode;
    private Map wuprops;

    public InboxDocController() {
        this.init();
    }

    public void init() {
        this.opener = new Opener();
        this.opener.setOutcome("blankpage");
    }

    public String getTitle() {
        return this.invoker == null ? "" : this.invoker.getCaption();
    }

    public String getContext() {
        if (this.context == null) {
            Object o = this.getWorkunitProperties().get("context");
            this.context = o == null ? "explorer" : o.toString();
        }
        return this.context;
    }

    public String getDefaultFileType() {
        if (this.defaultFileType == null) {
            Object o = this.getWorkunitProperties().get("defaultFileType");
            this.defaultFileType = o == null ? null : o.toString();
        }
        return this.defaultFileType;
    }

    public String getServiceName() {
        if (this.serviceName == null) {
            Object o = this.getWorkunitProperties().get("serviceName");
            this.serviceName = o == null ? null : o.toString();
        }
        return this.serviceName;
    }

    public List getFormActions() {
        if (this.formActions == null) {
            this.formActions = new ArrayList<Action>();
            this.formActions.add(this.createAction("reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
            String filetype = this.getDefaultFileType();
            if (filetype != null && filetype.length() > 0) {
                List<Invoker> invokers = this.actionsProvider.getInvokers(null, filetype.toLowerCase() + ":formActions");
                for (Invoker invoker : invokers) {
                    this.formActions.add(new ActionInvoker(invoker));
                }
            }
        }
        return this.formActions;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public TreeNodeModel getNodeModel() {
        if (this.nodeModel == null) {
            this.nodeModel = new TreeNodeModelImpl();
        }
        return this.nodeModel;
    }

    public ExplorerViewService getService() {
        String name = this.getServiceName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalStateException("Please specify a serviceName");
        }
        if (this.service == null) {
            this.service = (ExplorerViewService)InvokerProxy.getInstance().create(name, ExplorerViewService.class);
        }
        return this.service;
    }

    public boolean isRootVisible() {
        return false;
    }

    public String getIcon() {
        return null;
    }

    public Object getOpener() {
        return this.opener;
    }

    public final Node getSelectedOpenNode() {
        return this._selectedOpenNode;
    }

    protected final Map getWorkunitProperties() {
        if (this.wuprops == null) {
            try {
                PropertyResolver resolver = PropertyResolver.getInstance();
                this.wuprops = (Map)resolver.getProperty((Object)this.controller, "workunit.workunit.properties");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.wuprops == null) {
                if (this.controller == null) {
                    return new HashMap();
                }
                this.wuprops = new HashMap();
            }
        }
        return this.wuprops;
    }

    private void showOpener(Opener opener) {
        if (opener == null) {
            return;
        }
        Binding obinding = (Binding)this.getNodeModel().getBinding();
        if (obinding == null) {
            return;
        }
        this.opener = opener;
        obinding.refresh("selectedOpenNode|formActions|opener");
    }

    private void updateView() {
        this.buildActions();
        Node selNode = this.getSelectedOpenNode();
        String filetype = this.helper.getFiletype(selNode);
        if (filetype == null || filetype.length() == 0) {
            filetype = this.getDefaultFileType();
        }
        Invoker invoker = null;
        if (filetype != null && filetype.length() > 0) {
            String invtype = filetype.toLowerCase() + ":open";
            invoker = this.actionsProvider.getInvoker(selNode, invtype);
        }
        Opener opener = null;
        if (invoker != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("inboxHandler", new InboxDocHandler());
            params.put("node", selNode.getItem());
            params.put("entity", selNode.getItem());
            opener = this.actionsProvider.toOpener(invoker, params, selNode);
        } else {
            opener = new Opener();
            opener.setOutcome("blankpage");
        }
        this.showOpener(opener);
    }

    private void buildActions() {
        this.formActions.clear();
        this.formActions.add(this.createAction("reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
        Node node = this.getSelectedNode();
        if (node == null) {
            String filetype = this.getDefaultFileType();
            if (filetype != null && filetype.length() > 0) {
                String invtype = filetype.toLowerCase() + ":formActions";
                List<Invoker> invokers = this.actionsProvider.getInvokers(null, invtype);
                for (Invoker invoker : invokers) {
                    this.formActions.add(new ActionInvoker(invoker));
                }
            }
            return;
        }
        ArrayList<Invoker> list = node.getPropertyList("Invoker.formActions");
        if (list == null) {
            ArrayList<String> filetypes = new ArrayList<String>();
            String sval = this.getDefaultFileType();
            if (sval != null && sval.length() > 0) {
                filetypes.add(sval.toLowerCase());
            }
            if ((sval = this.helper.getFiletype(node)) != null && sval.length() > 0) {
                filetypes.remove(sval.toLowerCase());
                filetypes.add(sval.toLowerCase());
                sval = sval + ":" + node.getPropertyString("name");
                filetypes.remove(sval.toLowerCase());
                filetypes.add(sval.toLowerCase());
            }
            list = new ArrayList<Invoker>();
            for (String filetype : filetypes) {
                String invtype = filetype + ":formActions";
                list.addAll(this.actionsProvider.getInvokers(node, invtype));
            }
            node.setProperty("Invoker.formActions", list);
        }
        for (Invoker invoker : list) {
            this.formActions.add(new ActionInvoker(invoker));
        }
    }

    protected Action createAction(String name, String caption, String icon, String shortcut, char mnemonic, String visibleWhen, boolean immediate) {
        Action a = new Action(name, caption, icon, mnemonic);
        if (visibleWhen != null) {
            a.setVisibleWhen(visibleWhen);
        }
        if (shortcut != null) {
            a.getProperties().put("shortcut", shortcut);
        }
        a.setImmediate(immediate);
        a.setShowCaption(true);
        return a;
    }

    public void reload() {
        Node selNode = this.getSelectedOpenNode();
        if (selNode == null) {
            this.getNodeModel().reloadTree();
        } else {
            selNode.refresh();
            selNode.open();
        }
    }

    public class InboxDocHandler {
        InboxDocController root;

        public InboxDocHandler() {
            this.root = InboxDocController.this;
        }

        public void refresh() {
            Node selNode = this.root.getSelectedOpenNode();
            if (selNode != null) {
                selNode.refresh();
            }
        }

        public void reload() {
            Node selNode = this.root.getSelectedOpenNode();
            if (selNode != null) {
                selNode.reload();
            }
        }

        public void reloadTreeModel() {
            this.root.getNodeModel().reloadTree();
        }

        public void update(Object data) {
            Node selNode = this.root.getSelectedOpenNode();
            if (selNode == null) {
                return;
            }
            selNode.setItem(data);
            selNode.refresh();
        }

        public void remove() {
            Node selNode = this.root.getSelectedOpenNode();
            if (selNode == null) {
                return;
            }
            selNode.remove();
            selNode = this.root.getNodeModel().getSelectedNode();
            if (selNode == null) {
                this.clearView();
            }
        }

        public void clearView() {
            Opener opener = new Opener();
            opener.setOutcome("blankpage");
            this.root.showOpener(opener);
        }
    }

    private class Helper {
        private Helper() {
        }

        private String getString(Object bean, String name) {
            if (bean instanceof Map) {
                return this.getString((Map)bean, name);
            }
            return null;
        }

        private String getString(Map data, String name) {
            Object o = data == null ? null : (Object)data.get(name);
            return o == null ? null : o.toString();
        }

        private String getFiletype(Map data) {
            if (data == null) {
                return null;
            }
            String filetype = this.getString(data, "filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = this.getString(data, "_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype.toLowerCase();
        }

        private String getFiletype(Node node) {
            if (node == null) {
                return null;
            }
            String filetype = node.getPropertyString("filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = node.getPropertyString("_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype.toLowerCase();
        }

        private String getFiletype(Node node, String defaultFiletype) {
            if (node == null) {
                return null;
            }
            String filetype = node.getPropertyString("filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = node.getPropertyString("_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                filetype = defaultFiletype;
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype + ":" + node.getPropertyString("name");
        }
    }

    private class ActionInvoker
    extends Action {
        InboxDocController root;
        private Invoker invoker;

        ActionInvoker(Invoker invoker) {
            this.root = InboxDocController.this;
            this.invoker = invoker;
            this.setName(invoker.getAction());
            this.setCaption(invoker.getCaption());
            this.setIcon(this.getString("icon"));
            this.setVisibleWhen(this.getString("visibleWhen"));
            this.setMnemonic(this.getChar("mnemonic"));
            this.setTooltip(this.getString("tooltip"));
            Boolean bool = this.getBoolean("immediate");
            if (bool != null) {
                this.setImmediate(bool);
            }
            if ((bool = this.getBoolean("showCaption")) != null) {
                this.setShowCaption(bool);
            }
            this.getProperties().putAll(invoker.getProperties());
        }

        public Object execute() {
            Node node = this.root.getSelectedNode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("inboxHandler", new InboxDocHandler());
            map.put("node", node == null ? null : node.getItem());
            Opener opener = InboxDocController.this.actionsProvider.toOpener(this.invoker, map, node);
            String target = this.invoker.getProperties().get("target") + "";
            if (!target.matches("window|popup|process|_window|_popup|_process")) {
                this.root.showOpener(opener);
                return null;
            }
            return opener;
        }

        private String getString(String name) {
            if (this.invoker == null || this.invoker.getProperties() == null) {
                return null;
            }
            Object ov = this.invoker.getProperties().get(name);
            return ov == null ? null : ov.toString();
        }

        private char getChar(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.trim().length() == 0) {
                return '\u0000';
            }
            return sv.trim().charAt(0);
        }

        private Boolean getBoolean(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.length() == 0) {
                return null;
            }
            return "true".equalsIgnoreCase(sv);
        }
    }

    private class ActionsProvider {
        private ExpressionResolver resolver = ExpressionResolver.getInstance();

        private ActionsProvider() {
        }

        List<Invoker> getInvokers(Node node, String invokerType) {
            try {
                return InvokerUtil.lookup((String)invokerType);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error lookup '" + invokerType + "' caused by " + t.getMessage());
                return new ArrayList<Invoker>();
            }
        }

        Invoker getInvoker(Node node, String invokerType) {
            List<Invoker> list = this.getInvokers(node, invokerType);
            return list.isEmpty() ? null : list.get(0);
        }

        Opener toOpener(Invoker invoker, Map params, Node node) {
            Opener a;
            String target;
            Object nodeTitle = invoker.getProperties().get("formTitle");
            if (nodeTitle != null) {
                params.put("nodeTitle", nodeTitle);
            }
            if (!(target = (a = InvokerUtil.createOpener((Invoker)invoker, (Map)params)).getTarget() + "").matches("window|popup|process|_window|_popup|_process")) {
                a.setTarget("popup");
            }
            return a;
        }
    }

    private class TreeNodeModelImpl
    extends TreeNodeModel {
        InboxDocController root;

        private TreeNodeModelImpl() {
            this.root = InboxDocController.this;
        }

        public boolean isRootVisible() {
            return this.root.isRootVisible();
        }

        public String getIcon() {
            String icon = this.root.getIcon();
            if (icon == null || icon.length() == 0) {
                return "Tree.closedIcon";
            }
            return icon;
        }

        public List<Map> getNodeList(Node node) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object item = node.getItem();
            if (item instanceof Map) {
                params.putAll((Map)item);
            } else {
                params.put("item", node.getItem());
            }
            params.put("root", node.getParent() == null);
            params.put("caption", node.getCaption());
            List<Map> nodes = InboxDocController.this.getService().getNodes(params);
            if (nodes == null) {
                nodes = new ArrayList<Map>();
            }
            return nodes;
        }

        public void initChildNodes(Node[] nodes) {
            if (nodes == null) {
                return;
            }
            for (Node node : nodes) {
                Object o = node.getItem();
                String sfolder = InboxDocController.this.helper.getString(o, "folder");
                if (sfolder == null || sfolder.length() == 0) {
                    node.setLeaf(true);
                }
                if (node.getIcon() != null) continue;
                String icon = node.getPropertyString("filetype");
                if (icon == null) {
                    icon = "default_folder";
                }
                String path = "images/explorer/" + this.root.getContext();
                node.getProperties().put("iconpath", path);
                String res = path + "/" + icon.toLowerCase() + ".png";
                if (ControlSupport.isResourceExist((String)res)) {
                    node.setIcon(res);
                    continue;
                }
                node.setIcon(this.getIcon());
            }
        }

        public Object openFolder(Node node) {
            return this.openNodeImpl(node);
        }

        public Object openLeaf(Node node) {
            return this.openNodeImpl(node);
        }

        private Object openNodeImpl(Node node) {
            if (node == null) {
                return null;
            }
            System.out.println("openNode-> " + node.getItem());
            InboxDocController.this._selectedOpenNode = node;
            InboxDocController.this.updateView();
            return null;
        }
    }
}

