/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.common.ExplorerViewService;
import com.rameses.osiris2.common.ListController;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.ControlSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxController
extends ListController {
    private String context;
    private String defaultFileType;
    private String serviceName;
    private TreeNodeModel nodeModel;
    private Node selectedNode;
    private ExplorerViewService service;
    private List<Action> formActions;
    private ActionsProvider actionsProvider = new ActionsProvider();
    private Helper helper = new Helper();
    private Object itemStat;
    private List<Invoker> defaultCreateInvokers;
    private Invoker defaultCreateInvoker;
    private Invoker defaultOpenInvoker;
    private Node _selectedOpenNode;
    private Map wuprops;
    private String wucontext;
    private String wudefaultFileType;
    private String wuserviceName;
    private String wuentityName;
    private Boolean wudynamicColumns;
    private Boolean wuautoSelect;

    public void init() {
    }

    public String getContext() {
        if (this.wucontext == null || this.wucontext.length() == 0) {
            this.wucontext = "explorer";
        }
        return this.context;
    }

    public String getDefaultFileType() {
        return this.wudefaultFileType;
    }

    @Override
    public String getServiceName() {
        return this.wuserviceName;
    }

    @Override
    public String getEntityName() {
        return this.wuentityName;
    }

    public boolean isDynamicColumns() {
        if (this.wudynamicColumns == null) {
            return true;
        }
        return this.wudynamicColumns;
    }

    public boolean isAutoSelect() {
        if (this.wuautoSelect == null) {
            return true;
        }
        return this.wuautoSelect;
    }

    @Override
    public int getRows() {
        return 20;
    }

    @Override
    public List getFormActions() {
        if (this.formActions == null) {
            Action a;
            this.formActions = new ArrayList<Action>();
            this.formActions.add(this.createAction("reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
            if (!this.isAllowCreate()) {
                return this.formActions;
            }
            List<Invoker> invokers = this.getDefaultCreateInvokers();
            if (!invokers.isEmpty()) {
                a = this.createAction("create", "New", "images/toolbars/create.png", "ctrl N", 'n', null, true);
                this.formActions.add(a);
            }
            a = this.createAction("open", "Open", "images/toolbars/open.png", "ctrl O", 'o', "#{selectedEntity != null && openButtonVisible==true}", true);
            a.getProperties().put("depends", "selectedEntity");
            this.formActions.add(a);
        }
        return this.formActions;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public TreeNodeModel getNodeModel() {
        if (this.nodeModel == null) {
            this.nodeModel = new TreeNodeModelImpl();
        }
        return this.nodeModel;
    }

    @Override
    public ExplorerViewService getService() {
        String name = this.getServiceName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalStateException("Please specify a serviceName");
        }
        if (this.service == null) {
            this.service = (ExplorerViewService)InvokerProxy.getInstance().create(name, ExplorerViewService.class);
        }
        return this.service;
    }

    public boolean isRootVisible() {
        return false;
    }

    public String getIcon() {
        return null;
    }

    public String getListTitle() {
        Node node = this.getSelectedOpenNode();
        String s = node == null ? null : node.getCaption();
        return s == null ? " " : s;
    }

    public Object getItemStat() {
        return this.itemStat;
    }

    public void setItemStat(Object itemStat) {
        this.itemStat = itemStat;
    }

    public final Node getSelectedOpenNode() {
        return this._selectedOpenNode;
    }

    @Override
    public boolean isAllowSearch() {
        return true;
    }

    public final boolean isOpenButtonVisible() {
        List invokers;
        Node node = this.getSelectedNode();
        if (node != null && (invokers = node.getPropertyList("Invoker.openlist")) != null && !invokers.isEmpty()) {
            return true;
        }
        Object item = this.getSelectedEntity();
        if (item instanceof Map) {
            String filetype = this.helper.getFiletype((Map)item);
            if (filetype != null && filetype.length() > 0) {
                return true;
            }
            if (this.defaultOpenInvoker != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Map createOpenerParams() {
        Map params = super.createOpenerParams();
        params.put("listModelHandler", null);
        return params;
    }

    @Override
    protected void beforeGetColumns(Map params) {
        Object item;
        Node node = this.getSelectedNode();
        Object object = item = node == null ? null : node.getItem();
        if (item instanceof Map) {
            params.putAll((Map)item);
        }
    }

    @Override
    protected void onbeforeFetchList(Map params) {
        Object item;
        Node node = this.getSelectedNode();
        Object object = item = node == null ? null : node.getItem();
        if (item instanceof Map) {
            params.putAll((Map)item);
        }
    }

    @Override
    public Object open() throws Exception {
        List list;
        Map item = (Map)this.getSelectedEntity();
        if (item == null) {
            return null;
        }
        Node node = this.getSelectedNode();
        String itemfiletype = this.helper.getFiletype(item);
        if (itemfiletype != null && itemfiletype.length() > 0) {
            String invtype = itemfiletype.toLowerCase() + ":open";
            Invoker invoker = this.actionsProvider.getInvoker(node, invtype);
            if (invoker == null) {
                System.out.println("No available file type handler (" + invtype + ")");
                MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
                return null;
            }
            Map map = this.createOpenerParams();
            map.put("node", node == null ? null : node.getItem());
            map.put("entity", item);
            return this.actionsProvider.toOpener(invoker, map, node);
        }
        if (node != null && (list = node.getPropertyList("Invoker.openlist")) != null && !list.isEmpty()) {
            Map map = this.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", item);
            return this.actionsProvider.toOpener((Invoker)list.get(0), map, node);
        }
        String filetype = this.getDefaultFileType();
        if (filetype != null && filetype.length() > 0) {
            String invtype = filetype.toLowerCase() + ":open";
            Invoker invoker = this.actionsProvider.getInvoker(null, invtype);
            if (invoker != null) {
                Map map = this.createOpenerParams();
                map.put("node", null);
                return this.actionsProvider.toOpener(invoker, map, node);
            }
            System.out.println("No available file type handler (" + invtype + ")");
            MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
            return null;
        }
        return null;
    }

    @Override
    public Opener create() throws Exception {
        List<Invoker> invokers = null;
        Node node = this.getSelectedNode();
        if (node != null) {
            invokers = node.getPropertyList("Invoker.createlist");
        }
        if (invokers == null || invokers.isEmpty()) {
            invokers = this.getDefaultCreateInvokers();
        }
        if (invokers != null && !invokers.isEmpty()) {
            Map map = this.createOpenerParams();
            map.put("node", node == null ? null : node.getItem());
            PopupMenuOpener menu = new PopupMenuOpener();
            menu.setExecuteOnSingleResult(true);
            for (Invoker inv : invokers) {
                menu.add((Object)this.actionsProvider.toOpener(inv, map, node));
            }
            return menu;
        }
        System.out.println("No available file type handler");
        return null;
    }

    protected final Map getWorkunitProperties() {
        if (this.wuprops == null) {
            try {
                PropertyResolver resolver = PropertyResolver.getInstance();
                this.wuprops = (Map)resolver.getProperty((Object)this.controller, "workunit.workunit.properties");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.wuprops == null) {
                this.wuprops = new HashMap();
            }
        }
        return this.wuprops;
    }

    private void updateView() {
        this.getQuery().clear();
        this.buildActions();
        Binding obinding = (Binding)this.getNodeModel().getBinding();
        if (obinding != null) {
            obinding.refresh("selectedOpenNode|formActions");
        }
        if (this.isDynamicColumns()) {
            this.reloadAll();
        } else {
            this.reload();
        }
    }

    private List<Invoker> getDefaultInvokers(Node node, String mode) {
        String filetype = this.getDefaultFileType();
        if (filetype == null || filetype.length() == 0) {
            return new ArrayList<Invoker>();
        }
        String invtype = filetype.toLowerCase() + ":" + mode;
        return this.actionsProvider.getInvokers(node, invtype);
    }

    private List<Invoker> getDefaultCreateInvokers() {
        if (this.defaultCreateInvokers == null) {
            this.defaultCreateInvokers = new ArrayList<Invoker>();
            String dfiletype = this.getDefaultFileType();
            if (dfiletype == null || dfiletype.length() == 0) {
                return this.defaultCreateInvokers;
            }
            String invtype = dfiletype.toLowerCase() + ":create";
            this.defaultCreateInvokers.addAll(this.actionsProvider.getInvokers(null, invtype));
        }
        return this.defaultCreateInvokers;
    }

    private void buildActions() {
        Action a;
        String invtype;
        String sval;
        ArrayList<String> filetypes;
        List<Object> list;
        if (this.formActions == null) {
            this.formActions = new ArrayList<Action>();
        } else {
            this.formActions.clear();
        }
        this.formActions.add(this.createAction("reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
        boolean allowCreate = this.isAllowCreate();
        Node node = this.getSelectedNode();
        if (node == null && allowCreate) {
            List<Invoker> invokers = this.getDefaultCreateInvokers();
            if (!invokers.isEmpty()) {
                Action a2 = this.createAction("create", "New", "images/toolbars/create.png", "ctrl N", 'n', "#{allowCreate==true}", true);
                this.formActions.add(a2);
            }
            return;
        }
        if (allowCreate) {
            list = node.getPropertyList("Invoker.createlist");
            if (list == null) {
                filetypes = new ArrayList<String>();
                sval = this.getDefaultFileType();
                if (sval != null && sval.length() > 0) {
                    filetypes.add(sval.toLowerCase());
                }
                if ((sval = this.helper.getFiletype(node)) != null && sval.length() > 0) {
                    filetypes.remove(sval.toLowerCase());
                    filetypes.add(sval.toLowerCase());
                }
                list = new ArrayList<Invoker>();
                for (String filetype : filetypes) {
                    invtype = filetype + ":create";
                    list.addAll(this.actionsProvider.getInvokers(node, invtype));
                }
                node.setProperty("Invoker.createlist", list);
            }
            if (!list.isEmpty()) {
                a = this.createAction("create", "New", "images/toolbars/create.png", "ctrl N", 'n', "#{allowCreate==true}", true);
                this.formActions.add(a);
            }
        }
        if (this.isAllowOpen()) {
            list = node.getPropertyList("Invoker.openlist");
            if (list == null) {
                filetypes = new ArrayList();
                sval = this.getDefaultFileType();
                if (sval != null && sval.length() > 0) {
                    filetypes.add(sval.toLowerCase());
                }
                if ((sval = this.helper.getFiletype(node)) != null && sval.length() > 0) {
                    filetypes.remove(sval.toLowerCase());
                    filetypes.add(sval.toLowerCase());
                }
                list = new ArrayList();
                for (String filetype : filetypes) {
                    invtype = filetype + ":open";
                    list.addAll(this.actionsProvider.getInvokers(node, invtype));
                }
                node.setProperty("Invoker.openlist", list);
            }
            a = this.createAction("open", "Open", "images/toolbars/open.png", "ctrl O", 'o', "#{selectedEntity != null && openButtonVisible==true}", true);
            a.getProperties().put("depends", "selectedEntity");
            this.formActions.add(a);
        }
        if ((list = node.getPropertyList("Invoker.formActions")) == null) {
            filetypes = new ArrayList();
            sval = this.getDefaultFileType();
            if (sval != null && sval.length() > 0) {
                filetypes.add(sval.toLowerCase());
            }
            if ((sval = this.helper.getFiletype(node)) != null && sval.length() > 0) {
                filetypes.remove(sval.toLowerCase());
                filetypes.add(sval.toLowerCase());
                sval = sval + ":" + node.getPropertyString("name");
                filetypes.remove(sval.toLowerCase());
                filetypes.add(sval.toLowerCase());
            }
            list = new ArrayList();
            for (String filetype : filetypes) {
                invtype = filetype + ":formActions";
                list.addAll(this.actionsProvider.getInvokers(node, invtype));
            }
            node.setProperty("Invoker.formActions", list);
        }
        for (Invoker invoker : list) {
            this.formActions.add(new ActionInvoker(invoker));
        }
    }

    @Override
    protected void handleWorkunitProperties(Map props) {
        if (props == null) {
            return;
        }
        super.handleWorkunitProperties(props);
        this.wucontext = this.getString(props, "context");
        this.wudefaultFileType = this.getString(props, "defaultFileType");
        this.wuserviceName = this.getString(props, "serviceName");
        this.wuentityName = this.getString(props, "entityName");
        this.wudynamicColumns = this.getBoolean(props, "dynamicColumns");
        this.wuautoSelect = this.getBoolean(props, "autoSelect");
    }

    private class Helper {
        private Helper() {
        }

        private String getString(Object bean, String name) {
            if (bean instanceof Map) {
                return this.getString((Map)bean, name);
            }
            return null;
        }

        private String getString(Map data, String name) {
            Object o = data == null ? null : (Object)data.get(name);
            return o == null ? null : o.toString();
        }

        private String getFiletype(Map data) {
            if (data == null) {
                return null;
            }
            String filetype = this.getString(data, "filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = this.getString(data, "_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype.toLowerCase();
        }

        private String getFiletype(Node node) {
            if (node == null) {
                return null;
            }
            String filetype = node.getPropertyString("filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = node.getPropertyString("_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype.toLowerCase();
        }

        private String getFiletype(Node node, String defaultFiletype) {
            if (node == null) {
                return null;
            }
            String filetype = node.getPropertyString("filetype");
            if (filetype == null || filetype.length() == 0) {
                filetype = node.getPropertyString("_filetype");
            }
            if (filetype == null || filetype.length() == 0) {
                filetype = defaultFiletype;
            }
            if (filetype == null || filetype.length() == 0) {
                return null;
            }
            return filetype + ":" + node.getPropertyString("name");
        }
    }

    private class ActionInvoker
    extends Action {
        InboxController root;
        private Invoker invoker;

        ActionInvoker(Invoker invoker) {
            this.root = InboxController.this;
            this.invoker = invoker;
            this.setName(invoker.getAction());
            this.setCaption(invoker.getCaption());
            this.setIcon(this.getString("icon"));
            this.setVisibleWhen(this.getString("visibleWhen"));
            this.setMnemonic(this.getChar("mnemonic"));
            this.setTooltip(this.getString("tooltip"));
            Boolean bool = this.getBoolean("immediate");
            if (bool != null) {
                this.setImmediate(bool);
            }
            if ((bool = this.getBoolean("showCaption")) != null) {
                this.setShowCaption(bool);
            }
            this.getProperties().putAll(invoker.getProperties());
        }

        public Object execute() {
            Node node = this.root.getSelectedNode();
            Map map = this.root.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", (Map)this.root.getSelectedEntity());
            return InboxController.this.actionsProvider.toOpener(this.invoker, map, node);
        }

        private String getString(String name) {
            if (this.invoker == null || this.invoker.getProperties() == null) {
                return null;
            }
            Object ov = this.invoker.getProperties().get(name);
            return ov == null ? null : ov.toString();
        }

        private char getChar(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.trim().length() == 0) {
                return '\u0000';
            }
            return sv.trim().charAt(0);
        }

        private Boolean getBoolean(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.length() == 0) {
                return null;
            }
            return "true".equalsIgnoreCase(sv);
        }
    }

    private class ActionsProvider {
        private ExpressionResolver resolver = ExpressionResolver.getInstance();

        private ActionsProvider() {
        }

        List<Invoker> getInvokers(Node node, String invokerType) {
            try {
                return InvokerUtil.lookup((String)invokerType);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error lookup '" + invokerType + "' caused by " + t.getMessage());
                return new ArrayList<Invoker>();
            }
        }

        Invoker getInvoker(Node node, String invokerType) {
            List<Invoker> list = this.getInvokers(node, invokerType);
            return list.isEmpty() ? null : list.get(0);
        }

        Opener toOpener(Invoker invoker, Map params, Node node) {
            Opener a;
            String target;
            Object nodeTitle = invoker.getProperties().get("formTitle");
            if (nodeTitle != null) {
                params.put("nodeTitle", nodeTitle);
            }
            if (!(target = (a = InvokerUtil.createOpener((Invoker)invoker, (Map)params)).getTarget() + "").matches("window|popup|process|_window|_popup|_process")) {
                a.setTarget("popup");
            }
            return a;
        }
    }

    private class TreeNodeModelImpl
    extends TreeNodeModel {
        InboxController root;

        private TreeNodeModelImpl() {
            this.root = InboxController.this;
        }

        public boolean isRootVisible() {
            return this.root.isRootVisible();
        }

        public boolean isAutoSelect() {
            return this.root.isAutoSelect();
        }

        public String getIcon() {
            String icon = this.root.getIcon();
            if (icon == null || icon.length() == 0) {
                return "Tree.closedIcon";
            }
            return icon;
        }

        public List<Map> getNodeList(Node node) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object item = node.getItem();
            if (item instanceof Map) {
                params.putAll((Map)item);
            } else {
                params.put("item", node.getItem());
            }
            params.put("root", node.getParent() == null);
            params.put("caption", node.getCaption());
            List<Map> nodes = InboxController.this.getService().getNodes(params);
            if (nodes == null) {
                nodes = new ArrayList<Map>();
            }
            return nodes;
        }

        public void initChildNodes(Node[] nodes) {
            if (nodes == null) {
                return;
            }
            for (Node node : nodes) {
                Object o = node.getItem();
                String sfolder = InboxController.this.helper.getString(o, "folder");
                if (sfolder == null || sfolder.length() == 0) {
                    node.setLeaf(true);
                }
                if (node.getIcon() != null) continue;
                String icon = node.getPropertyString("filetype");
                if (icon == null) {
                    icon = "default_folder";
                }
                String path = "images/explorer/" + this.root.getContext();
                node.getProperties().put("iconpath", path);
                String res = path + "/" + icon.toLowerCase() + ".png";
                if (ControlSupport.isResourceExist((String)res)) {
                    node.setIcon(res);
                    continue;
                }
                node.setIcon(this.getIcon());
            }
        }

        public Object openFolder(Node node) {
            return this.openNodeImpl(node);
        }

        public Object openLeaf(Node node) {
            return this.openNodeImpl(node);
        }

        private Object openNodeImpl(Node node) {
            if (node == null) {
                return null;
            }
            InboxController.this._selectedOpenNode = node;
            InboxController.this.updateView();
            return null;
        }
    }
}

