/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.MethodResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerFilter;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.osiris2.common.ListModelHandler;
import com.rameses.osiris2.common.PageListModelHandler;
import com.rameses.rcp.annotations.ChangeLog;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ChangeLogHandler;
import com.rameses.util.ExceptionManager;
import com.rameses.util.MapEditor;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CRUDController {
    public static final String MODE_CREATE = "create";
    public static final String MODE_EDIT = "edit";
    public static final String MODE_READ = "read";
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    @com.rameses.rcp.annotations.Binding
    protected Binding binding;
    @ChangeLog
    private com.rameses.rcp.framework.ChangeLog changeLog;
    private ListModelHandler listModelHandler;
    private List formActions;
    private List navActions;
    private List extActions;
    private CRUDServiceProxy serviceProxy;
    private MapEditor mapEditor;
    private Map entity = new HashMap();
    private String mode = "read";
    protected String styleSource;

    public String getServiceName() {
        throw new NullPointerException("Please specify a serviceName");
    }

    public String getEntityName() {
        throw new NullPointerException("Please specify an entityName");
    }

    public String getIcon() {
        return null;
    }

    public String getPreferredTitle() {
        return this.invoker == null ? null : this.invoker.getCaption();
    }

    public String getTitle() {
        String text = this.getPreferredTitle();
        if (text == null) {
            text = "Title";
        }
        if (MODE_CREATE.equals(this.getMode())) {
            return text + " (New)";
        }
        if (MODE_EDIT.equals(this.getMode())) {
            return text + " (Edit)";
        }
        return text;
    }

    public final String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Map getEntity() {
        return this.entity;
    }

    public void setEntity(Map entity) {
        this.entity = entity;
        if (entity != null && entity.get("state") == null) {
            entity.put("state", "DRAFT");
        }
        this.entityChanged();
    }

    protected void entityChanged() {
    }

    public Object getService() {
        String name = this.getServiceName();
        if (name == null || name.trim().length() == 0) {
            throw new NullPointerException("Please specify a serviceName");
        }
        return InvokerProxy.getInstance().create(name);
    }

    public final boolean isDirty() {
        return this.changeLog.hasChanges();
    }

    public ListModelHandler getListModelHandler() {
        return this.listModelHandler;
    }

    public void setListModelHandler(ListModelHandler listModelHandler) {
        this.listModelHandler = listModelHandler;
    }

    protected Map getChanges() {
        final HashMap map = new HashMap();
        if (this.changeLog.hasChanges()) {
            ChangeLogHandler handler = new ChangeLogHandler(){
                private String fldname;

                public void clear(com.rameses.rcp.framework.ChangeLog log) {
                }

                public void end() {
                }

                public void endEntity() {
                }

                public void endField() {
                }

                public void showChange(Object oldValue, Object newValue) {
                    HashMap<String, Object> diff = new HashMap<String, Object>();
                    diff.put("oldvalue", oldValue);
                    diff.put("newvalue", newValue);
                    map.put(this.fldname, diff);
                }

                public void showHistory(Date timeChanged, Object oldValue, Object newValue) {
                }

                public void start() {
                }

                public void startEntity(Object entity) {
                }

                public void startField(String fieldName) {
                    this.fldname = fieldName;
                }
            };
            this.changeLog.scan(handler);
        }
        return map;
    }

    public String getDomain() {
        return null;
    }

    public String getRole() {
        return null;
    }

    public boolean isAllowCreate() {
        return true;
    }

    public boolean isAllowOpen() {
        return true;
    }

    public boolean isAllowEdit() {
        return true;
    }

    public boolean isAllowDelete() {
        return true;
    }

    public boolean isAllowApprove() {
        return true;
    }

    public boolean isShowFormActions() {
        return true;
    }

    public boolean isCanEdit() {
        Object o = this.entity != null ? this.entity.get("state") : null;
        return "DRAFT".equals(o + "");
    }

    public boolean isCanDelete() {
        Object o = this.entity != null ? this.entity.get("state") : null;
        return "DRAFT".equals(o + "");
    }

    public boolean isCanApprove() {
        Object o = this.entity != null ? this.entity.get("state") : null;
        return "DRAFT".equals(o + "");
    }

    protected boolean isShowConfirmOnSave() {
        return true;
    }

    protected boolean isShowNavigationBar() {
        return true;
    }

    public String getCreateFocusComponent() {
        return "entity.code";
    }

    public String getEditFocusComponent() {
        return "entity.description";
    }

    public String getConfirmSaveMsg() {
        return null;
    }

    public String getConfirmApproveMsg() {
        return null;
    }

    public String getConfirmDeleteMsg() {
        return null;
    }

    public Map getCreatePermission() {
        return null;
    }

    public Map getEditPermission() {
        return null;
    }

    public Map getDeletePermission() {
        return null;
    }

    public Map getApprovePermission() {
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    protected String getPrefixId() {
        return "MF";
    }

    public List getStyleRules() {
        ArrayList<StyleRule> list = new ArrayList<StyleRule>();
        list.add(new StyleRule("entity.*", "#{mode=='read'}").add("enabled", (Object)false));
        list.add(new StyleRule("entity.*", "#{mode!='read'}").add("enabled", (Object)true));
        return list;
    }

    public boolean isAllowSave() {
        return true;
    }

    public List getFormActions() {
        if (this.formActions == null) {
            if (!this.isShowFormActions()) {
                return null;
            }
            this.formActions = new ArrayList();
            this.formActions.add(this.createAction("close", "Close", "images/toolbars/cancel.png", "ctrl C", 'c', "#{mode=='read'}", true));
            Action a = this.createAction(MODE_CREATE, "New", "images/toolbars/create.png", "ctrl N", 'n', "#{mode=='read' && allowCreate==true}", true);
            this.loadPermissionDefaults(a, MODE_CREATE);
            this.loadPermission(a, this.getCreatePermission());
            this.formActions.add(a);
            a = this.createAction(MODE_EDIT, "Edit", "images/toolbars/edit.png", "ctrl E", 'e', "#{mode=='read' && allowEdit==true && canEdit==true}", true);
            this.loadPermissionDefaults(a, MODE_EDIT);
            this.loadPermission(a, this.getEditPermission());
            this.formActions.add(a);
            a = this.createAction("delete", "Delete", "images/toolbars/trash.png", null, 'd', "#{mode=='read' && allowDelete==true && canDelete==true}", true);
            this.loadPermissionDefaults(a, "delete");
            this.loadPermission(a, this.getDeletePermission());
            this.formActions.add(a);
            a = this.createAction("approve", "Approve", "images/toolbars/approve.png", null, 'v', "#{mode=='read' && allowApprove==true && canApprove==true}", true);
            this.loadPermissionDefaults(a, "approve");
            this.loadPermission(a, this.getApprovePermission());
            this.formActions.add(a);
            this.formActions.add(this.createAction("cancel", "Cancel", "images/toolbars/cancel.png", "ctrl C", 'c', "#{mode!='read'}", true));
            this.formActions.add(this.createAction("save", "Save", "images/toolbars/save.png", "ctrl S", 's', "#{mode!='read' && allowSave==true}", false));
            this.formActions.add(this.createAction("undo", "Undo", "images/toolbars/undo.png", "ctrl Z", 'u', "#{mode=='edit'}", true));
        }
        return this.formActions;
    }

    public List getNavActions() {
        if (this.navActions == null) {
            this.navActions = new ArrayList();
            if (this.isShowNavigationBar()) {
                this.navActions.add(this.createAction("moveBackRecord", "Move to previous record", "images/toolbars/arrow_up.png", null, '\u0000', "#{navButtonVisible==true}", true));
                this.navActions.add(this.createAction("moveNextRecord", "Move to next record", "images/toolbars/arrow_down.png", null, '\u0000', "#{navButtonVisible==true}", true));
            }
        }
        return this.navActions;
    }

    public boolean isNavButtonVisible() {
        if (!MODE_READ.equals(this.getMode())) {
            return false;
        }
        return this.getListModelHandler() instanceof PageListModelHandler;
    }

    public List getExtActions() {
        if (this.extActions == null) {
            // empty if block
        }
        return this.extActions;
    }

    protected final List<Action> lookupActions(String type) {
        List<Action> actions = new ArrayList();
        try {
            actions = InvokerUtil.lookupActions((String)type, (InvokerFilter)new InvokerFilter(){

                public boolean accept(Invoker o) {
                    return o.getWorkunitid().equals(CRUDController.this.invoker.getWorkunitid());
                }
            });
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup actions caused by " + t.getMessage());
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action newAction = actions.get(i).clone();
            actions.set(i, newAction);
        }
        return actions;
    }

    private Action createAction(String name, String caption, String icon, String shortcut, char mnemonic, String visibleWhen, boolean immediate) {
        Action a = new Action(name, caption, icon, mnemonic);
        if (shortcut != null) {
            a.getProperties().put("shortcut", shortcut);
        }
        if (visibleWhen != null) {
            a.setVisibleWhen(visibleWhen);
        }
        a.setImmediate(immediate);
        return a;
    }

    protected Map createEntity() {
        return new LinkedHashMap();
    }

    protected void beforeCreate(Object data) {
    }

    protected void afterCreate(Object data) {
    }

    protected void onInit() {
    }

    public final void init() {
        this.onInit();
        Map data = this.createEntity();
        if (data.get("objid") == null) {
            data.put("objid", this.getPrefixId() + new UID());
        }
        if (data.get("state") == null) {
            data.put("state", "DRAFT");
        }
        this.beforeCreate(data);
        this.setEntity(data);
        this.mode = MODE_CREATE;
        this.afterCreate(data);
        this.focusComponent(this.getCreateFocusComponent());
    }

    public Object create() {
        this.init();
        return null;
    }

    protected void beforeCancel() {
    }

    protected void afterCancel() {
    }

    public Object cancel() {
        if (MODE_EDIT.equals(this.mode)) {
            if (!MsgBox.confirm((Object)"Changes will be discarded. Continue?")) {
                return null;
            }
            this.beforeCancel();
            if (this.changeLog.hasChanges()) {
                this.changeLog.undoAll();
                this.changeLog.clear();
            }
            this.mode = MODE_READ;
            this.afterCancel();
            return null;
        }
        return this.close();
    }

    protected void beforeClose() {
    }

    protected void onClosing() {
    }

    public Object close() {
        this.beforeClose();
        this.mode = MODE_READ;
        this.changeLog.clear();
        this.onClosing();
        return "_close";
    }

    @Deprecated
    protected void onbeforeSave() {
    }

    @Deprecated
    protected void onafterSave() {
    }

    protected void beforeSave(Object data) {
    }

    protected void afterSave(Object data) {
    }

    protected void afterSaveCreate(Object data) {
    }

    protected void afterSaveUpdate(Object data) {
    }

    public Object save() {
        this.onbeforeSave();
        Map oldData = this.getEntity();
        this.beforeSave(oldData);
        if (this.isShowConfirmOnSave()) {
            String msg = this.getConfirmSaveMsg();
            if (msg == null || msg.length() == 0) {
                msg = "You are about to save this record. Continue?";
            }
            if (!MsgBox.confirm((Object)msg)) {
                return null;
            }
        }
        Map newData = null;
        if (MODE_CREATE.equals(this.mode)) {
            oldData.put("createdby", OsirisContext.getEnv().get("USERID"));
            newData = this.getServiceProxy().create(oldData);
            if (newData != null) {
                this.setEntity(newData);
            }
        } else if (MODE_EDIT.equals(this.mode)) {
            oldData.put("modifiedby", OsirisContext.getEnv().get("USERID"));
            newData = this.getServiceProxy().update(oldData);
            if (newData != null) {
                this.setEntity(newData);
            }
        }
        String oldmode = this.mode;
        this.mode = MODE_READ;
        this.changeLog.clear();
        if (MODE_CREATE.equals(oldmode)) {
            this.afterSaveCreate(newData);
        } else if (MODE_EDIT.equals(oldmode)) {
            this.afterSaveUpdate(newData);
        }
        this.afterSave(this.getEntity());
        ListModelHandler lm = this.getListModelHandler();
        if (lm != null) {
            if (MODE_EDIT.equals(oldmode)) {
                lm.updateItem(this.getEntity());
            } else if (MODE_CREATE.equals(oldmode)) {
                lm.addItem(this.getEntity());
            }
        }
        return null;
    }

    protected void beforeOpen(Object params) {
    }

    protected void afterOpen(Object data) {
    }

    public Object open() {
        if (!this.isAllowOpen()) {
            throw new IllegalStateException("PERMISSION DENIED! Invoking this method is not authorized.");
        }
        this.onInit();
        HashMap params = this.getEntity();
        if (params == null) {
            params = new HashMap();
        }
        this.beforeOpen(params);
        Map data = this.getServiceProxy().open(params);
        if (data == null) {
            throw new NullPointerException("Record does not exist");
        }
        if (data.get("state") == null) {
            data.put("state", "DRAFT");
        }
        this.setEntity(data);
        this.mode = MODE_READ;
        this.afterOpen(data);
        return null;
    }

    protected void beforeEdit(Object data) {
    }

    protected void afterEdit(Object data) {
    }

    public Object edit() {
        if (!this.isAllowEdit()) {
            throw new IllegalStateException("PERMISSION DENIED! Invoking this method is not authorized.");
        }
        Map data = this.getEntity();
        this.beforeEdit(data);
        this.mode = MODE_EDIT;
        this.afterEdit(data);
        this.focusComponent(this.getEditFocusComponent());
        return null;
    }

    protected void beforeUndo(Object data) {
    }

    protected void afterUndo(Object data) {
    }

    public void undo() {
        Map data = this.getEntity();
        this.beforeUndo(data);
        this.changeLog.undo();
        this.afterUndo(data);
    }

    protected void beforeApprove(Object data) {
    }

    protected void afterApprove(Object data) {
    }

    public Object approve() {
        String msg = this.getConfirmApproveMsg();
        if (msg == null || msg.length() == 0) {
            msg = "You are about to approve this document. Continue?";
        }
        if (MsgBox.confirm((Object)msg)) {
            Map data = this.getEntity();
            this.beforeApprove(data);
            this.getServiceProxy().approve(data);
            data.put("state", "APPROVED");
            this.afterApprove(data);
        }
        return null;
    }

    protected void beforeDelete(Object data) {
    }

    protected void afterDelete(Object data) {
    }

    public Object delete() {
        String msg = this.getConfirmDeleteMsg();
        if (msg == null || msg.length() == 0) {
            msg = "You are about to delete this document. Continue?";
        }
        if (MsgBox.confirm((Object)msg)) {
            Map data = this.getEntity();
            this.beforeDelete(data);
            this.getServiceProxy().removeEntity(data);
            ListModelHandler lm = this.getListModelHandler();
            if (lm != null) {
                lm.removeItem(data);
            }
            this.afterDelete(data);
            return this.close();
        }
        return null;
    }

    public void moveBackRecord() {
        ListModelHandler lm = this.getListModelHandler();
        if (lm != null && lm instanceof PageListModelHandler) {
            ((PageListModelHandler)lm).moveBackRecord();
            Object data = lm.getSelectedEntity();
            if (data == null) {
                return;
            }
            this.entity = (Map)data;
            this.open();
            if (this.binding != null) {
                if (this.isDynamic()) {
                    this.formActions.clear();
                    this.formActions = null;
                }
                this.binding.refresh();
            }
        }
    }

    public void moveNextRecord() {
        ListModelHandler lm = this.getListModelHandler();
        if (lm != null && lm instanceof PageListModelHandler) {
            ((PageListModelHandler)lm).moveNextRecord();
            Object data = lm.getSelectedEntity();
            if (data == null) {
                return;
            }
            this.entity = (Map)data;
            this.open();
            if (this.binding != null) {
                if (this.isDynamic()) {
                    this.formActions.clear();
                    this.formActions = null;
                }
                this.binding.refresh();
            }
        }
    }

    private void focusComponent(String ctrlname) {
        if (this.binding != null) {
            this.binding.focus(ctrlname);
        }
    }

    private void loadPermission(Action a, Map perm) {
        String permission;
        String role;
        if (perm == null || perm.isEmpty()) {
            return;
        }
        String domain = this.getString(perm, "domain");
        if (domain != null && domain.length() > 0) {
            a.setDomain(domain);
        }
        if ((role = this.getString(perm, "role")) != null && role.length() > 0) {
            a.setRole(role);
        }
        if ((permission = this.getString(perm, "permission")) != null && permission.length() > 0) {
            a.setPermission(permission);
        }
    }

    private void loadPermissionDefaults(Action a, String permission) {
        String domain = this.getDomain();
        if ((domain == null || domain.length() == 0) && this.invoker != null) {
            domain = this.invoker.getDomain();
        }
        a.setDomain(domain);
        String role = this.getRole();
        if (role == null || role.length() == 0) {
            return;
        }
        a.setRole(role);
        String entityName = this.getEntityName();
        if (entityName != null && entityName.length() != 0 && permission != null && permission.length() > 0) {
            a.setPermission(entityName + "." + permission);
        }
    }

    private String getString(Map map, String name) {
        Object ov = map == null ? null : (Object)map.get(name);
        return ov == null ? null : ov.toString();
    }

    private CRUDServiceProxy getServiceProxy() {
        if (this.serviceProxy == null) {
            this.serviceProxy = new CRUDServiceProxy();
        }
        if (this.serviceProxy.serviceObj == null) {
            this.serviceProxy.serviceObj = this.getService();
        }
        return this.serviceProxy;
    }

    private class CRUDServiceProxy {
        Object serviceObj;
        MethodResolver resolver = MethodResolver.getInstance();

        private CRUDServiceProxy() {
        }

        Map create(Map data) {
            return (Map)this.invoke(CRUDController.MODE_CREATE, data);
        }

        Map open(Map data) {
            return (Map)this.invoke("open", data);
        }

        Map update(Map data) {
            return (Map)this.invoke("update", data);
        }

        void removeEntity(Map data) {
            this.invoke("removeEntity", data);
        }

        Map approve(Map data) {
            return (Map)this.invoke("approve", data);
        }

        Object invoke(String methodName, Object data) {
            try {
                if (this.serviceObj == null) {
                    throw new NullPointerException("No available service object");
                }
                return this.resolver.invoke(this.serviceObj, methodName, new Object[]{data});
            }
            catch (Exception re) {
                Exception e = ExceptionManager.getOriginal((Exception)re);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

