/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class ContentPanel
extends JPanel {
    private JPanel body;
    private JToolBar toolbar;
    private JButton uploadButton;
    private JButton imageButton;

    public ContentPanel() {
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout());
    }

    protected void upload() {
    }

    protected void download() {
    }

    protected void showImageList() {
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof JToolBar) {
            this.toolbar = (JToolBar)comp;
            Component[] comps = this.toolbar.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (i >= 3) continue;
                this.toolbar.remove(comps[i]);
            }
            if (this.uploadButton == null) {
                this.uploadButton = new UploadAction().createButton();
                this.toolbar.addSeparator();
                this.toolbar.add(this.uploadButton);
            }
            if (this.imageButton == null) {
                this.imageButton = new ImageListAction().createButton();
                this.toolbar.addSeparator();
                this.toolbar.add(this.imageButton);
            }
        } else if (comp instanceof JPanel) {
            this.body = (JPanel)comp;
        }
    }

    void scanDown(Component c, final int level) {
        if (c == null) {
            return;
        }
        String str = this.createSpaces(level) + "(" + level + ") " + c;
        System.out.println(str);
        if (c instanceof Container) {
            Container con = (Container)c;
            con.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    ContentPanel.this.scanDown(e.getChild(), level + 1);
                }

                @Override
                public void componentRemoved(ContainerEvent e) {
                }
            });
            Component[] comps = con.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.scanDown(comps[i], level + 1);
            }
        }
    }

    String createSpaces(int level) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            buff.append("   ");
        }
        return buff.toString();
    }

    class ImageListAction
    implements ActionListener {
        ImageListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.showImageList();
        }

        JButton createButton() {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/image-16.png"));
            JButton btn = new JButton();
            btn.setIcon(icon);
            btn.setToolTipText("View Uploaded Images ...");
            btn.setBorder(null);
            btn.setBorderPainted(false);
            btn.setMaximumSize(new Dimension(22, 22));
            btn.setMinimumSize(new Dimension(22, 22));
            btn.setPreferredSize(new Dimension(22, 22));
            btn.addActionListener(this);
            return btn;
        }
    }

    class DownloadAction
    implements ActionListener {
        DownloadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.download();
        }

        JButton createButton() {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/download-16.png"));
            JButton btn = new JButton();
            btn.setIcon(icon);
            btn.setToolTipText("Download Images from Server");
            btn.setBorder(null);
            btn.setBorderPainted(false);
            btn.setMaximumSize(new Dimension(22, 22));
            btn.setMinimumSize(new Dimension(22, 22));
            btn.setPreferredSize(new Dimension(22, 22));
            btn.addActionListener(this);
            return btn;
        }
    }

    class UploadAction
    implements ActionListener {
        UploadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.upload();
        }

        JButton createButton() {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/upload-16.png"));
            JButton btn = new JButton();
            btn.setIcon(icon);
            btn.setToolTipText("Upload Changes to Server...");
            btn.setBorder(null);
            btn.setBorderPainted(false);
            btn.setMaximumSize(new Dimension(22, 22));
            btn.setMinimumSize(new Dimension(22, 22));
            btn.setPreferredSize(new Dimension(22, 22));
            btn.addActionListener(this);
            return btn;
        }
    }
}

