/*
 * Decompiled with CFR 0.152.
 */
package ireport.designer.models;

import com.rameses.io.IOStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileConf {
    private final Object TREE_LOCKED = new Object();
    private File file;
    private List<KeyValuePair> values = new ArrayList<KeyValuePair>();

    public static FileConf parse(File file) {
        return new FileConf().parseImpl(file);
    }

    private FileConf() {
    }

    private FileConf parseImpl(File file) {
        if (!file.exists()) {
            this.file = file;
            return this;
        }
        FileInputStream fis = null;
        BufferedReader br = null;
        InputStreamReader sr = null;
        try {
            fis = new FileInputStream(file);
            sr = new InputStreamReader(fis);
            br = new BufferedReader(sr);
            String lineText = null;
            while ((lineText = br.readLine()) != null) {
                KeyValuePair kv = new KeyValuePair();
                if (lineText.trim().length() == 0) {
                    kv.comment = lineText;
                } else if (lineText.trim().startsWith("#")) {
                    kv.comment = lineText;
                } else {
                    String str = lineText.trim();
                    int idx = str.indexOf("=");
                    if (idx > 0) {
                        kv.key = str.substring(0, idx);
                        kv.val = str.substring(idx + 1);
                        kv.comment = null;
                    } else {
                        kv.comment = lineText;
                    }
                }
                this.values.add(kv);
            }
            this.file = file;
            FileConf fileConf = this;
            return fileConf;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable throwable) {}
            try {
                sr.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Object object = this.TREE_LOCKED;
        synchronized (object) {
            if (key == null) {
                return null;
            }
            KeyValuePair kv = new KeyValuePair();
            kv.key = key;
            int idx = this.values.indexOf(kv);
            if (idx < 0) {
                return null;
            }
            Object val = this.values.get((int)idx).val;
            if (val == null || val.toString().length() == 0) {
                return null;
            }
            return val.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        Object object = this.TREE_LOCKED;
        synchronized (object) {
            KeyValuePair kv = new KeyValuePair();
            kv.key = key;
            kv.val = value;
            int idx = this.values.indexOf(kv);
            if (idx < 0) {
                this.values.add(kv);
            } else {
                KeyValuePair old = this.values.get(idx);
                old.val = value;
            }
            KeyValuePair[] pairs = this.values.toArray(new KeyValuePair[0]);
            String content = this.toContentString(pairs);
            this.writeToFile(content);
        }
    }

    private String toContentString(KeyValuePair[] pairs) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < pairs.length; ++i) {
            if (i > 0) {
                buff.append("\n");
            }
            buff.append(pairs[i].toString());
        }
        return buff.toString();
    }

    private void writeToFile(String content) {
        FileOutputStream fos = null;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content.getBytes());
            fos = new FileOutputStream(this.file);
            IOStream.write((InputStream)bais, (OutputStream)fos);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private class KeyValuePair {
        String comment;
        String key;
        Object val;

        private KeyValuePair() {
        }

        public String toString() {
            if (this.comment != null) {
                return this.comment;
            }
            return (this.key == null ? "" : this.key) + "=" + (this.val == null ? "" : this.val.toString());
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyValuePair) {
                KeyValuePair kv = (KeyValuePair)obj;
                if (kv.key == null) {
                    return false;
                }
                if (this.key == null) {
                    return false;
                }
                if (this.key.equals(kv.key)) {
                    return true;
                }
            }
            return super.equals(obj);
        }
    }
}

