/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.io.IOStream;
import com.rameses.jasper.models.SysReportLocalConf;
import com.rameses.rcp.common.IReportDesignerModel;
import com.rameses.util.ConfigProperties;
import it.businesslogic.ireport.gui.MainFrameImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class IReportDesigner {
    private static final Config config = new Config();
    private static final Object FRAME_LOCKED = new Object();
    private static MainFrameImpl frame = null;
    private static JFileChooser imageFileChooser;

    public static Config getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVisibled() {
        Object object = FRAME_LOCKED;
        synchronized (object) {
            if (frame == null) {
                return false;
            }
            return frame.isVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(IReportDesignerModel model) {
        Object object = FRAME_LOCKED;
        synchronized (object) {
            if (frame == null) {
                frame = new MainFrameImpl(model);
                MainFrameImpl.main(frame);
            } else {
                frame.reopen(model);
            }
        }
    }

    public static JFileChooser getImageFileChooser() {
        if (imageFileChooser == null) {
            imageFileChooser = new JFileChooser();
        }
        imageFileChooser.setFileSelectionMode(0);
        imageFileChooser.setSelectedFile(null);
        imageFileChooser.setSelectedFiles(null);
        imageFileChooser.setMultiSelectionEnabled(true);
        imageFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return false;
                }
                return f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".gif");
            }

            @Override
            public String getDescription() {
                return "Image Files (*.png, *.jpg, *.gif)";
            }
        });
        return imageFileChooser;
    }

    public static class Config {
        final Object PREF_LOCKED = new Object();
        private File fileConf;

        Config() {
            URL url = this.getClass().getResource("/ireport/designer/conf/config.xml");
            if (url != null) {
                this.writeFile(url, "config.xml");
            }
            if ((url = this.getClass().getResource("/ireport/designer/conf/recentFiles.xml")) != null) {
                this.writeFile(url, "recentFiles.xml");
            }
            File app_dir = SysReportLocalConf.getInstance().getAppDir();
            this.fileConf = new File(app_dir, "client.conf");
            if (!this.fileConf.exists()) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(this.fileConf);
                    fos.write("".getBytes());
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public File getTempDir() {
            return SysReportLocalConf.getInstance().getTempDir();
        }

        public File getCustomDir() {
            return SysReportLocalConf.getInstance().getCustomDir();
        }

        public File getUserDir() {
            return SysReportLocalConf.getInstance().getUserDir();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getProperties() {
            Object object = this.PREF_LOCKED;
            synchronized (object) {
                return new ConfigProperties(this.fileConf).getProperties();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLocation() {
            Object object = this.PREF_LOCKED;
            synchronized (object) {
                Object value = new ConfigProperties(this.fileConf).getProperty("ireport.home");
                return value == null ? null : value.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLocation(String location) {
            Object object = this.PREF_LOCKED;
            synchronized (object) {
                ConfigProperties cp = new ConfigProperties(this.fileConf);
                cp.put("ireport.home", location);
                cp.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getWorkspaceDir() {
            Object object = this.PREF_LOCKED;
            synchronized (object) {
                Object value = new ConfigProperties(this.fileConf).getProperty("report.tmpdir");
                if (value != null && value.toString().trim().length() > 0) {
                    return value.toString();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkspaceDir(String value) {
            Object object = this.PREF_LOCKED;
            synchronized (object) {
                ConfigProperties cp = new ConfigProperties(this.fileConf);
                cp.put("report.tmpdir", value);
                cp.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(URL sourceURL, String targetName) {
            if (sourceURL == null) {
                return;
            }
            SysReportLocalConf.getInstance().update();
            FileOutputStream fos = null;
            try {
                File file = new File(this.getUserDir(), targetName);
                fos = new FileOutputStream(file);
                IOStream.write((URL)sourceURL, (OutputStream)fos);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable file) {}
            }
        }
    }
}

