/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.etracs.common;

import com.rameses.rcp.common.CallbackHandler;
import com.rameses.rcp.control.XComboBox;
import com.rameses.rcp.control.XFormPanel;
import com.rameses.rcp.control.XLookupField;
import com.rameses.rcp.control.XPanel;
import com.rameses.rcp.control.XTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.UIEvent;
import com.rameses.rcp.framework.UIHandler;
import com.rameses.rcp.ui.UIControlAdapter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JPanel;

public class NonLocalAddressPanel
extends JPanel {
    private XComboBox cboType;
    private XLookupField lupBarangay;
    private XPanel pnlwhich;
    private XTextField txtBldgname;
    private XTextField txtBldgno;
    private XTextField txtPin;
    private XTextField txtStreet;
    private XTextField txtSubdivision;
    private XTextField txtUnitno;
    private XTextField txtcity;
    private XTextField txtmuni;
    private XTextField txtprov;
    private XFormPanel xFormPanel1;
    private XFormPanel xFormPanel2;
    private XFormPanel xFormPanel3;
    private XFormPanel xFormPanel4;

    public NonLocalAddressPanel() {
        this.initComponents();
        this.register("entity");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.txtUnitno.setName(name + ".unitno");
        this.txtBldgno.setName(name + ".bldgno");
        this.txtBldgname.setName(name + ".bldgname");
        this.txtStreet.setName(name + ".street");
        this.txtSubdivision.setName(name + ".subdivision");
        this.lupBarangay.setName(name + ".barangay");
        this.lupBarangay.setExpression("#{" + name + ".barangay.name}");
        this.txtPin.setName(name + ".pin");
        this.cboType.setName(name + ".addresstype");
        this.txtmuni.setName(name + ".municipality");
        this.txtcity.setName(name + ".city");
        this.txtprov.setName(name + ".province");
        String[] depends = new String[]{name + ".addresstype"};
        this.pnlwhich.setDepends(depends);
        this.register(name);
    }

    private void register(String name) {
        ControlHandlerImpl uihandler = new ControlHandlerImpl(name);
        this.txtUnitno.putClientProperty(UIHandler.class, (Object)uihandler);
    }

    private void initComponents() {
        this.xFormPanel1 = new XFormPanel();
        this.xFormPanel2 = new XFormPanel();
        this.txtUnitno = new XTextField();
        this.txtBldgno = new XTextField();
        this.txtBldgname = new XTextField();
        this.txtStreet = new XTextField();
        this.xFormPanel3 = new XFormPanel();
        this.txtSubdivision = new XTextField();
        this.lupBarangay = new XLookupField();
        this.xFormPanel4 = new XFormPanel();
        this.cboType = new XComboBox();
        this.pnlwhich = new XPanel();
        this.txtmuni = new XTextField();
        this.txtcity = new XTextField();
        this.txtprov = new XTextField();
        this.txtPin = new XTextField();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.xFormPanel1.setCaptionVAlignment("CENTER");
        this.xFormPanel1.setCaptionWidth(100);
        this.xFormPanel1.setName("entity");
        this.xFormPanel2.setCaptionVAlignment("CENTER");
        this.xFormPanel2.setOrientation("HORIZONTAL");
        this.xFormPanel2.setPadding(new Insets(0, 0, 0, 0));
        this.xFormPanel2.setShowCaption(false);
        this.xFormPanel2.setStretchWidth(100);
        this.txtUnitno.setCaption("Unit No ");
        this.txtUnitno.setCaptionWidth(100);
        this.txtUnitno.setName("entity.unitno");
        this.txtUnitno.setStretchWidth(100);
        this.xFormPanel2.add((Component)this.txtUnitno);
        this.txtBldgno.setCaption("House / Bldg No");
        this.txtBldgno.setCaptionWidth(90);
        this.txtBldgno.setCellPadding(new Insets(0, 5, 0, 0));
        this.txtBldgno.setName("entity.bldgno");
        this.txtBldgno.setStretchWidth(100);
        this.xFormPanel2.add((Component)this.txtBldgno);
        this.xFormPanel1.add((Component)this.xFormPanel2);
        this.txtBldgname.setCaption("Bldg Name");
        this.txtBldgname.setName("entity.bldgname");
        this.txtBldgname.setStretchWidth(100);
        this.xFormPanel1.add((Component)this.txtBldgname);
        this.txtStreet.setCaption("Street");
        this.txtStreet.setName("entity.street");
        this.txtStreet.setStretchWidth(100);
        this.xFormPanel1.add((Component)this.txtStreet);
        this.xFormPanel3.setOrientation("HORIZONTAL");
        this.xFormPanel3.setPadding(new Insets(0, 0, 0, 0));
        this.xFormPanel3.setShowCaption(false);
        this.xFormPanel3.setStretchWidth(100);
        this.txtSubdivision.setCaption("Subdivision");
        this.txtSubdivision.setCaptionWidth(100);
        this.txtSubdivision.setName("entity.subdivision");
        this.txtSubdivision.setStretchWidth(100);
        this.xFormPanel3.add((Component)this.txtSubdivision);
        this.lupBarangay.setCaption("Barangay");
        this.lupBarangay.setCaptionWidth(90);
        this.lupBarangay.setCellPadding(new Insets(0, 5, 0, 0));
        this.lupBarangay.setExpression("#{entity.barangay.name}");
        this.lupBarangay.setHandler("barangay:lookup");
        this.lupBarangay.setName("entity.barangay");
        this.lupBarangay.setStretchWidth(100);
        this.xFormPanel3.add((Component)this.lupBarangay);
        this.xFormPanel1.add((Component)this.xFormPanel3);
        this.xFormPanel4.setCaptionVAlignment("CENTER");
        this.xFormPanel4.setOrientation("HORIZONTAL");
        this.xFormPanel4.setPadding(new Insets(0, 0, 0, 0));
        this.xFormPanel4.setShowCaption(false);
        this.xFormPanel4.setStretchWidth(100);
        this.cboType.setAllowNull(false);
        this.cboType.setCaption("Address Type");
        this.cboType.setCaptionWidth(120);
        this.cboType.setItemsObject((Object)new String[]{"MUNICIPALITY", "CITY"});
        this.cboType.setName("entity.addresstype");
        this.cboType.setPreferredSize(new Dimension(100, 20));
        this.cboType.setShowCaption(false);
        this.xFormPanel4.add((Component)this.cboType);
        this.pnlwhich.setDepends(new String[]{"entity.addresstype"});
        this.pnlwhich.setName("entity.addresstype");
        this.pnlwhich.setShowCaption(false);
        this.pnlwhich.setStretchWidth(100);
        this.pnlwhich.setLayout((LayoutManager)new CardLayout());
        this.txtmuni.setCaption("Municipality");
        this.txtmuni.setCaptionWidth(120);
        this.txtmuni.setName("entity.municipality");
        this.txtmuni.setRequired(true);
        this.txtmuni.setStretchWidth(100);
        this.pnlwhich.add((Component)this.txtmuni, (Object)"MUNICIPALITY");
        this.txtcity.setCaption("City");
        this.txtcity.setCaptionWidth(120);
        this.txtcity.setName("entity.city");
        this.txtcity.setPreferredSize(new Dimension(0, 22));
        this.txtcity.setRequired(true);
        this.pnlwhich.add((Component)this.txtcity, (Object)"CITY");
        this.xFormPanel4.add((Component)this.pnlwhich);
        this.txtprov.setCaption("Province");
        this.txtprov.setCaptionWidth(90);
        this.txtprov.setCellPadding(new Insets(0, 5, 0, 0));
        this.txtprov.setName("entity.province");
        this.txtprov.setRequired(true);
        this.txtprov.setStretchWidth(100);
        this.xFormPanel4.add((Component)this.txtprov);
        this.xFormPanel1.add((Component)this.xFormPanel4);
        this.txtPin.setCaption("PIN");
        this.txtPin.setName("entity.pin");
        this.txtPin.setStretchWidth(50);
        this.xFormPanel1.add((Component)this.txtPin);
        this.add((Component)this.xFormPanel1, "Center");
    }

    private class ControlHandlerImpl
    extends UIControlAdapter
    implements CallbackHandler {
        String name;
        UIEvent uie;

        ControlHandlerImpl(String name) {
            this.name = name == null ? "entity" : name;
        }

        public void bind(UIEvent uie) {
            this.uie = uie;
            if (uie != null) {
                Binding binding;
                Object o = uie.getValue(this.name);
                if (o == null) {
                    uie.setValue(this.name, new HashMap());
                }
                if ((binding = uie.getBinding()) != null) {
                    binding.getValueChangeSupport().add(this.name + ".*", (Object)this);
                }
            }
        }

        public void unbind(UIEvent e) {
            this.uie = null;
        }

        public void refresh(UIEvent e) {
            if (this.uie != null) {
                this.call("");
            }
        }

        public Object call(Object arg) {
            if (this.uie != null) {
                StringBuilder buffer = new StringBuilder();
                this.append(buffer, " ", "unitno");
                this.append(buffer, " ", "bldgno");
                this.append(buffer, " ", "bldgname");
                this.append(buffer, ", ", "street");
                this.append(buffer, ", ", "subdivision");
                this.append(buffer, ", ", "barangay.name");
                String addrtype = this.uie.getValue(this.name + ".addresstype") + "";
                if ("CITY".equalsIgnoreCase(addrtype)) {
                    this.append(buffer, ", ", "city");
                } else if ("MUNICIPALITY".equalsIgnoreCase(addrtype)) {
                    this.append(buffer, ", ", "municipality");
                }
                this.append(buffer, ", ", "province");
                if (buffer.length() > 0) {
                    this.uie.setValue(this.name + ".text", (Object)buffer.toString());
                } else {
                    this.uie.setValue(this.name + ".text", null);
                }
            }
            return null;
        }

        public Object call() {
            return null;
        }

        public Object call(Object[] args) {
            return null;
        }

        private void append(StringBuilder buffer, String delimiter, String property) {
            Object o = this.uie.getValue(this.name + "." + property);
            if (o == null) {
                return;
            }
            if (buffer.length() > 0) {
                buffer.append(delimiter == null ? "" : delimiter);
            }
            buffer.append(o.toString());
        }
    }
}

