/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.io.IOStream;
import com.rameses.osiris2.reports.Base64URLStreamHandler;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.Base64Cipher;
import com.rameses.util.Encoder;
import com.rameses.util.URLStreamHandler;
import com.rameses.util.URLStreamHandlers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReportURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private URLStreamHandlerFactory source = URLStreamHandlers.getFactory();
    private File developerCustomFolder;
    private boolean developerMode;
    public static String CACHE_NAME = "rameses_cache_resource";

    public File getDeveloperCustomFolder() {
        return this.developerCustomFolder;
    }

    public void setDeveloperCustomFolder(File developerCustomFolder) {
        this.developerCustomFolder = developerCustomFolder;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public ClassLoader getClassLoader() {
        ClientContext ctx = ClientContext.getCurrentContext();
        ClassLoader loader = ctx == null ? null : ctx.getClassLoader();
        return loader == null ? this.getClass().getClassLoader() : loader;
    }

    public InputStream getWebResourceAsStream(String resname) {
        try {
            URL u = this.getWebResource(resname);
            return u == null ? null : u.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getWebResource(String resname) {
        if (resname == null || resname.trim().length() == 0) {
            return null;
        }
        Map env = ClientContext.getCurrentContext().getAppEnv();
        String reshost = this.getString(env, "res.host");
        if (reshost != null && reshost.trim().length() > 0) {
            try {
                CacheResource cache = new CacheResource();
                URL oURL = cache.getResource(resname);
                if (oURL != null) {
                    return oURL;
                }
                String shost = "http://" + reshost + "/" + resname;
                oURL = new URL(shost);
                oURL.openStream();
                cache.put(resname, oURL);
                return oURL;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (FileNotFoundException mue) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL u = this.getResource(name);
            return u == null ? null : u.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getResource(String name) {
        if (name == null) {
            return null;
        }
        try {
            return this.getResourceImpl(name);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private URL getResourceImpl(String name) throws Exception {
        Map env;
        String customName;
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        File customFolder = null;
        if (this.isDeveloperMode()) {
            customFolder = this.getDeveloperCustomFolder();
        }
        if ((customName = this.getString(env = ClientContext.getCurrentContext().getAppEnv(), "report.custom")) == null || customName.trim().length() == 0) {
            customName = this.getString(env, "app.custom");
        }
        String preferredName = name;
        String customReportName = null;
        if (customName != null && customName.trim().length() > 0) {
            String sDir = name.substring(0, name.lastIndexOf("/"));
            String sFname = name.substring(name.lastIndexOf("/"));
            customReportName = sDir + "/" + customName + (String)sFname;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (customFolder != null) {
            names.addAll(this.getReportNames(customReportName));
            names.addAll(this.getReportNames(preferredName));
            for (String tmpname : names) {
                File ofile = new File(customFolder, tmpname);
                if (!ofile.exists() || !ofile.isFile()) continue;
                return ofile.toURI().toURL();
            }
        }
        names.clear();
        names.addAll(this.getReportNames(customReportName));
        names.addAll(this.getReportNames(preferredName));
        ClassLoader loader = this.getClassLoader();
        for (String tmpname : names) {
            URL u = loader.getResource(tmpname);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    private List<String> getReportNames(String name) {
        ArrayList<String> names = new ArrayList<String>();
        if (name == null || name.trim().length() == 0) {
            return names;
        }
        Map env = ClientContext.getCurrentContext().getAppEnv();
        String printerName = this.getString(env, "printer.name");
        if (printerName != null && printerName.length() > 0) {
            int idx = name.lastIndexOf(".");
            String str = name.substring(0, idx);
            names.add(str + "." + printerName + name.substring(idx));
        }
        names.add(name);
        return names;
    }

    @Override
    public java.net.URLStreamHandler createURLStreamHandler(String protocol) {
        return this.getHandler(protocol);
    }

    public URLStreamHandler getHandler(String protocol) {
        if (protocol == null || protocol.length() == 0) {
            return null;
        }
        if ("classpath".equalsIgnoreCase(protocol)) {
            return new ClasspathURLStreamHandler();
        }
        if ("webresource".equalsIgnoreCase(protocol)) {
            return new WebResURLStreamHandler();
        }
        if ("base64".equalsIgnoreCase(protocol)) {
            return new Base64URLStreamHandler();
        }
        return null;
    }

    private String getString(Map source, Object key) {
        Object value = source == null ? null : (Object)source.get(key);
        return value == null ? null : value.toString();
    }

    public static File getCacheDir() {
        File dir = new File(System.getProperty("java.io.tmpdir"), CACHE_NAME);
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        return dir;
    }

    public static class CacheResource {
        final Base64Cipher cipher = new Base64Cipher();

        public boolean contains(String name) {
            File file = this.get(name);
            return file != null;
        }

        public File get(String name) {
            String enckey;
            File dir = ReportURLStreamHandlerFactory.getCacheDir();
            File file = new File(dir, enckey = Encoder.MD5.encode(name).toLowerCase());
            return file.isFile() ? file : null;
        }

        public URL getResource(String name) {
            File file = this.get(name);
            if (file == null) {
                return null;
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            try {
                return url == null ? null : url.openStream();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        public void put(String name, File file) {
            try {
                this.put(name, file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        public void put(String name, URL url) {
            this.put(name, IOStream.toByteArray((URL)url));
        }

        public void put(String name, byte[] bytes) {
            String encdata = this.cipher.encode(bytes);
            String enckey = Encoder.MD5.encode(name).toLowerCase();
            File dir = ReportURLStreamHandlerFactory.getCacheDir();
            File file = new File(dir, enckey);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                IOStream.write((InputStream)new ByteArrayInputStream(bytes), (OutputStream)fos);
            }
            catch (FileNotFoundException ffe) {
                throw new RuntimeException(ffe.getMessage(), ffe);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class WebResURLStreamHandler
    extends URLStreamHandler {
        ReportURLStreamHandlerFactory root;

        private WebResURLStreamHandler() {
            this.root = ReportURLStreamHandlerFactory.this;
        }

        public String getProtocol() {
            return "webresource";
        }

        public URL getResource(String spath) {
            return ReportURLStreamHandlerFactory.this.getWebResource(spath);
        }
    }

    private class ClasspathURLStreamHandler
    extends URLStreamHandler {
        ReportURLStreamHandlerFactory root;

        private ClasspathURLStreamHandler() {
            this.root = ReportURLStreamHandlerFactory.this;
        }

        public String getProtocol() {
            return "classpath";
        }

        public URL getResource(String spath) {
            URL result = null;
            if (spath.startsWith("images/")) {
                result = ReportURLStreamHandlerFactory.this.getWebResource(spath);
            }
            if (result == null) {
                result = this.root.getResource(spath);
            }
            return result;
        }
    }
}

