/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.osiris2.reports.ReportModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

public abstract class ReportExporter {
    public static Properties index = new Properties();
    public static Map<String, ReportExporter> exporters = new HashMap<String, ReportExporter>();

    public static final ReportExporter get(String name) {
        if (exporters.get(name) == null && index.containsKey(name)) {
            try {
                ClassLoader loader = ReportExporter.class.getClassLoader();
                exporters.put(name, (ReportExporter)loader.loadClass(index.getProperty(name)).newInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return exporters.get(name);
    }

    public abstract JRExporter getExporter();

    public final void export(ReportModel model, String output) {
        try {
            this.export(model, new FileOutputStream(output));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void export(ReportModel model, File output) {
        try {
            this.export(model, new FileOutputStream(output));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void export(ReportModel model, OutputStream output) {
        OutputStream os = null;
        try {
            JasperPrint jp = model.getReport();
            JRExporter exporter = this.getExporter();
            os = output;
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
            exporter.exportReport();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        try {
            Enumeration<URL> e = ReportExporter.class.getClassLoader().getResources("META-INF/report-exporters.properties");
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                index.load(u.openStream());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

