/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.reports.ReportDataSource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class ReportDataUtil {
    private static ReportDataUtil instance;

    public static final ReportDataUtil getInstance() {
        if (instance == null) {
            instance = new ReportDataUtil();
        }
        return instance;
    }

    private Object resolveObject(Object obj) {
        if (obj instanceof ReportDataSource) {
            return ((ReportDataSource)obj).getSource();
        }
        return obj;
    }

    public BigDecimal toBigDecimal(Object value) {
        Object obj = this.resolveObject(value);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(obj.toString());
    }

    public Integer toInteger(Object value) {
        Object obj = this.resolveObject(value);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return new Integer(obj.toString());
    }

    public Double toDouble(Object value) {
        Object obj = this.resolveObject(value);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return new Double(obj.toString());
    }

    public boolean isEmpty(Object value) {
        Object obj = this.resolveObject(value);
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof List) {
            return ((List)obj).isEmpty();
        }
        return false;
    }

    public Object ifNull(Object value, Object defaultValue) {
        Object obj = this.resolveObject(value);
        return obj == null ? defaultValue : obj;
    }

    public Object getValue(Object bean, String name) {
        try {
            if (bean == null) {
                return null;
            }
            Object obj = this.resolveObject(bean);
            if (obj == null) {
                return null;
            }
            return PropertyResolver.getInstance().getProperty(obj, name);
        }
        catch (Throwable ex) {
            System.out.println("ReportDataUtil.getValue: [ERROR_" + ex.getClass().getName() + "] " + ex.getMessage());
            return null;
        }
    }

    public BigDecimal getBigDecimal(Object bean, String name) {
        Object value = this.getValue(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public Integer getInteger(Object bean, String name) {
        Object value = this.getValue(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return new Integer(value.toString());
    }

    public String getString(Object bean, String name) {
        Object value = this.getValue(bean, name);
        return value == null ? null : value.toString();
    }

    public Date getDate(Object bean, String name) {
        Object value = this.getValue(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return java.sql.Date.valueOf(value.toString());
    }

    public Timestamp getTimestamp(Object bean, String name) {
        Object value = this.getValue(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        return Timestamp.valueOf(value.toString());
    }

    private Date convertDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        Date dt = null;
        try {
            dt = java.sql.Date.valueOf(value.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (dt == null) {
                dt = Timestamp.valueOf(value.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dt;
    }

    public int getDaysDiff(Object dtfrom, Object dtto) {
        Date startDate = this.convertDate(dtfrom);
        Date endDate = this.convertDate(dtto);
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        long startMillis = startCal.getTimeInMillis();
        long endMillis = endCal.getTimeInMillis();
        long diff = endMillis - startMillis;
        return (int)(diff / 86400000L + 1L);
    }

    public int getYearsDiff(Object dtfrom, Object dtto) {
        Date startDate = this.convertDate(dtfrom);
        Date endDate = this.convertDate(dtto);
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        int years = 0;
        if (startCal.get(1) != endCal.get(1)) {
            while (startCal.before(endCal)) {
                startCal.add(1, 1);
                ++years;
            }
        }
        return years;
    }

    public String padLeft(Object value, String padstr, Number numlen) {
        if (numlen != null && numlen.intValue() > 0) {
            return this.padLeft(value, padstr, numlen.intValue());
        }
        return null;
    }

    public String padLeft(Object value, String padstr, int length) {
        if (value == null) {
            return null;
        }
        if (padstr == null || padstr.length() == 0) {
            return null;
        }
        String str = value.toString();
        if (str.length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int diff = length - str.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(padstr);
        }
        sb.append(str);
        return sb.toString();
    }

    public String padRight(Object value, String padstr, Number numlen) {
        if (numlen != null && numlen.intValue() > 0) {
            return this.padRight(value, padstr, numlen.intValue());
        }
        return null;
    }

    public String padRight(Object value, String padstr, int length) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        if (str.length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        int diff = length - str.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(padstr);
        }
        return sb.toString();
    }
}

