/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.osiris2.reports.ReportDataSource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class ReportDataSourceHelper
implements JRDataSource {
    private SimpleDateFormat dateFormatter;
    private SimpleDateFormat dateTimeFormatter;
    private Map<String, DecimalFormat> numberFormats;
    private Object source;

    public ReportDataSourceHelper() {
        this(null);
    }

    public ReportDataSourceHelper(Object source) {
        this.source = source;
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.numberFormats = new HashMap<String, DecimalFormat>();
    }

    public boolean next() throws JRException {
        return false;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        return null;
    }

    private DecimalFormat getNumberFormat(String pattern) {
        DecimalFormat decf;
        if (pattern == null) {
            pattern = "#,##0.00";
        }
        if ((decf = this.numberFormats.get(pattern)) == null) {
            decf = new DecimalFormat(pattern);
            this.numberFormats.put(pattern, decf);
        }
        return decf;
    }

    public Object resolveObject(Object obj) {
        if (obj instanceof ReportDataSource) {
            return ((ReportDataSource)obj).getSource();
        }
        return obj;
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Date toDate() {
        return this.toDate(this.source);
    }

    public Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return this.convertDate(value, false);
    }

    public Timestamp toDateTime() {
        return this.toDateTime(this.source);
    }

    public Timestamp toDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        return (Timestamp)this.convertDate(value, true);
    }

    public BigDecimal toDecimal() {
        return this.toDecimal(this.source);
    }

    public BigDecimal toDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public Integer toInteger() {
        return this.toInteger(this.source);
    }

    public Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        return new Integer(value.toString());
    }

    public Long toLong() {
        return this.toLong(this.source);
    }

    public Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        return new Long(value.toString());
    }

    private Date convertDate(Object value, boolean allowHourMinSec) {
        try {
            if (value == null) {
                return null;
            }
            String[] arr = value.toString().split(" ");
            if (allowHourMinSec) {
                Date dt = null;
                dt = arr.length > 1 ? this.dateTimeFormatter.parse(value.toString()) : this.dateFormatter.parse(arr[0]);
                return new Timestamp(dt.getTime());
            }
            Date dt = this.dateFormatter.parse(arr[0]);
            return new java.sql.Date(dt.getTime());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public int getDaysDiff(Object dtfrom, Object dtto) {
        Date startDate = this.convertDate(dtfrom, false);
        Date endDate = this.convertDate(dtto, false);
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        long startMillis = startCal.getTimeInMillis();
        long endMillis = endCal.getTimeInMillis();
        long diff = endMillis - startMillis;
        return (int)(diff / 86400000L + 1L);
    }

    public int getYearsDiff(Object dtfrom, Object dtto) {
        Date startDate = this.convertDate(dtfrom, false);
        Date endDate = this.convertDate(dtto, false);
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        int years = 0;
        if (startCal.get(1) != endCal.get(1)) {
            while (startCal.before(endCal)) {
                startCal.add(1, 1);
                ++years;
            }
        }
        return years;
    }

    public int getQtr() {
        return this.getQtr(this.source);
    }

    public int getQtr(Object value) {
        Date dt = this.toDate(value);
        if (dt == null) {
            return -1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int month = cal.get(2) + 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        if (month >= 10 && month <= 12) {
            return 4;
        }
        return -1;
    }

    public String formatNumber(String pattern) {
        return this.formatNumber(this.source, pattern);
    }

    public String formatNumber(String pattern, String zerovalue) {
        return this.formatNumber(this.source, pattern, zerovalue);
    }

    public String formatNumber(Object value, String pattern) {
        return this.formatNumber(value, pattern, null);
    }

    public String formatNumber(Object value, String pattern, String zerovalue) {
        BigDecimal num = this.toDecimal(value);
        if (num == null) {
            return zerovalue;
        }
        if (num.doubleValue() != 0.0) {
            return this.getNumberFormat(pattern).format(num);
        }
        if (zerovalue == null) {
            return this.getNumberFormat(pattern).format(num);
        }
        return zerovalue;
    }
}

