/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.osiris2.reports.DynamicReportUtil;
import com.rameses.osiris2.reports.ReportDataSource;
import com.rameses.osiris2.reports.ReportModel;
import com.rameses.rcp.common.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DynamicReportModel
extends ReportModel {
    private String name = "Report_1";
    private List<Column> columns = new ArrayList<Column>();
    private Object data;
    private JasperPrint report;
    private int topMargin = 0;
    private int leftMargin = 0;
    private int bottomMargin = 0;
    private int rightMargin = 0;
    private String orientation;
    private int pageWidth;
    private int pageHeight;
    private String reportHeader;
    private int reportHeaderHeight;
    private boolean showColumnHeaderPerPage = true;

    public DynamicReportModel() {
    }

    public DynamicReportModel(String name) {
        this.name = name;
    }

    public void addColumn(Column c) {
        this.columns.add(c);
    }

    public void addColumn(String name, Class c, int width) {
        Column col = new Column();
        col.setName(name);
        col.setWidth(width);
        col.setType(c.getName());
        this.addColumn(col);
    }

    @Override
    public JasperPrint getReport() {
        if (this.report == null) {
            this.buildReport();
        }
        return this.report;
    }

    public void buildReport() {
        try {
            JasperDesign jd = DynamicReportUtil.build(this);
            JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
            ReportDataSource ds = new ReportDataSource(this.getReportData());
            this.report = JasperFillManager.fillReport((JasperReport)jr, new HashMap(), (JRDataSource)ds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List getColumns() {
        return this.columns;
    }

    @Override
    public Object getReportData() {
        return this.data;
    }

    public void setReportData(Object data) {
        this.data = data;
    }

    @Override
    public String getReportName() {
        return this.name;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public int getReportHeaderHeight() {
        return this.reportHeaderHeight;
    }

    public void setReportHeaderHeight(int reportHeaderHeight) {
        this.reportHeaderHeight = reportHeaderHeight;
    }

    public String getReportHeader() {
        return this.reportHeader;
    }

    public void setReportHeader(String reportHeader) {
        this.reportHeader = reportHeader;
    }

    public boolean isShowColumnHeaderPerPage() {
        return this.showColumnHeaderPerPage;
    }

    public void setShowColumnHeaderPerPage(boolean showColumnHeaderPerPage) {
        this.showColumnHeaderPerPage = showColumnHeaderPerPage;
    }
}

