/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.entity.components;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.ComponentBean;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.control.XLookupField;
import com.rameses.rcp.control.XToolBar;
import com.rameses.rcp.ui.UIFocusableContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

@com.rameses.rcp.ui.annotations.ComponentBean(value="com.rameses.entity.components.EntityLookupModel")
public class EntityLookup
extends XComponentPanel
implements UIFocusableContainer {
    private String onselect;
    private String onempty;
    private String entityType;
    private String entityTypeName;
    private boolean allowCreate;
    private boolean allowOpen;
    private XButton btnAdd;
    private XButton btnView;
    private JPanel jPanel1;
    private XToolBar xToolBar1;
    private XLookupField xlookup;

    public EntityLookup() {
        this.initComponents();
        this.xToolBar1.setRollover(true);
        this.xToolBar1.setFloatable(false);
    }

    public void setName(String name) {
        super.setName(name);
        String[] depends = null;
        depends = name == null || name.trim().length() == 0 ? new String[]{"actions"} : new String[]{"actions", name};
        this.btnView.setDepends(depends);
        this.btnAdd.setDepends(depends);
    }

    public String getExpression() {
        return this.xlookup.getExpression();
    }

    public void setExpression(String expression) {
        this.xlookup.setExpression(expression);
    }

    public String getOnselect() {
        return this.onselect;
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public String getOnempty() {
        return this.onempty;
    }

    public void setOnempty(String onempty) {
        this.onempty = onempty;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entitytype) {
        this.entityType = entitytype;
    }

    public boolean focusFirstInput() {
        return this.xlookup.focusFirstInput();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.xlookup.setEnabled(enabled);
        this.btnAdd.setEnabled(enabled);
        ComponentBean bean = (ComponentBean)this.getComponentBean();
        bean.setProperty("allowCreate", (Object)enabled);
        bean.setProperty("allowOpen", (Object)true);
    }

    public void afterLoad() {
        Object handler;
        super.afterLoad();
        Object caller = this.getBean();
        Object bean = this.getComponentBean();
        PropertyResolver pr = PropertyResolver.getInstance();
        if (this.getOnselect() != null) {
            handler = pr.getProperty(caller, this.getOnselect());
            pr.setProperty(bean, "onselect", handler);
        }
        if (this.getOnempty() != null) {
            handler = pr.getProperty(caller, this.getOnempty());
            pr.setProperty(bean, "onempty", handler);
        }
        pr.setProperty(bean, "entityTypeCaller", (Object)new EntityTypeCaller(this.getEntityTypeName(), this.getEntityType(), caller));
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public void setEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
    }

    public String getFontStyle() {
        return this.xlookup.getFontStyle();
    }

    public void setFontStyle(String style) {
        this.xlookup.setFontStyle(style);
    }

    private void initComponents() {
        this.xlookup = new XLookupField();
        this.jPanel1 = new JPanel();
        this.xToolBar1 = new XToolBar();
        this.btnView = new XButton();
        this.btnAdd = new XButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.xlookup.setExpression("#{entity.name} - #{entity.entityno} ");
        this.xlookup.setHandler("lookupEntity");
        this.xlookup.setName("entity");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.xlookup, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.xToolBar1.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.xToolBar1.setOpaque(false);
        this.btnView.setDisableWhen("#{allowOpen != true}");
        this.btnView.setName("viewEntity");
        this.btnView.setFocusable(false);
        this.btnView.setHorizontalTextPosition(0);
        this.btnView.setIconResource("images/toolbars/open.png");
        this.btnView.setMargin(new Insets(0, 0, 0, 0));
        this.btnView.setToolTipText("View Record");
        this.xToolBar1.add((Component)this.btnView);
        this.btnAdd.setCaption("");
        this.btnAdd.setDisableWhen("#{allowCreate != true}");
        this.btnAdd.setName("addEntity");
        this.btnAdd.setVisibleWhen("#{allowCreate == true}");
        this.btnAdd.setFocusable(false);
        this.btnAdd.setHorizontalTextPosition(0);
        this.btnAdd.setIconResource("images/toolbars/create.png");
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnAdd.setToolTipText("Add New Record");
        this.xToolBar1.add((Component)this.btnAdd);
        this.jPanel1.add((Component)this.xToolBar1, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.add(this.jPanel1, gridBagConstraints);
    }

    public class EntityTypeCaller {
        private String type;
        private Object caller;
        private String entityTypeName;

        EntityTypeCaller(String entityTypename, String type, Object caller) {
            this.type = type;
            this.caller = caller;
            this.entityTypeName = entityTypename;
        }

        public Object getEntityType() {
            if (this.entityTypeName != null && this.entityTypeName.trim().length() > 0) {
                PropertyResolver pr = PropertyResolver.getInstance();
                Object r = pr.getProperty(this.caller, this.entityTypeName);
                return r;
            }
            if (this.type != null && this.type.trim().length() > 0) {
                return this.type;
            }
            return null;
        }
    }
}

